package com.baijia.tianxiao.dal.finance.dao.impl;

import com.baijia.tianxiao.dal.finance.dao.TxTransferClassInfoDao;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassInfo;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created by wengshengli on 2017/4/21.
 */
@Repository
@Slf4j
public class TxTransferClassInfoDaoImpl extends JdbcTemplateDaoSupport<TxTransferClassInfo> implements TxTransferClassInfoDao {

    @Override
    public int updateStatus(Long transferNumber, Integer status) {
        StringBuilder sb = new StringBuilder("update yunying.tx_transfer_class_info set status = :status where transfer_number = :transferNumber");
        Map<String, Object> params = Maps.newHashMap();
        params.put("status", status);
        params.put("transferNumber", transferNumber);
        return this.getNamedJdbcTemplate().update(sb.toString(), params);
    }

    @Override
    public TxTransferClassInfo getByTransferNumber(Long transferNumber) {
        SingleSqlBuilder<TxTransferClassInfo> sqlBuilder = this.createSqlBuilder();
        sqlBuilder.eq("transferNumber", transferNumber);
        return uniqueResult(sqlBuilder);
    }

    @Override
    public List<TxTransferClassInfo> listByTransferNumber(Set<Long> transferNumbers) {
        SingleSqlBuilder<TxTransferClassInfo> sqlBuilder = this.createSqlBuilder();
        sqlBuilder.in("transferNumber", transferNumbers);
        return queryList(sqlBuilder);
    }

    @Override
    public TxTransferClassInfo getByInPurchaseId(Long inPurchaseId) {
        SingleSqlBuilder<TxTransferClassInfo> sqlBuilder = this.createSqlBuilder();
        sqlBuilder.eq("transferInPurchaseId", inPurchaseId);
        return uniqueResult(sqlBuilder);
    }

    @Override
    public List<TxTransferClassInfo> listByUserIds(Collection<Long> userIds, Collection<Integer> status) {
        SingleSqlBuilder<TxTransferClassInfo> sqlBuilder = this.createSqlBuilder();
        sqlBuilder.in("userId", userIds);
        if (status != null && status.size() > 0) {
            sqlBuilder.in("status", status);
        }
        return queryList(sqlBuilder);
    }

    @Override
    public List<TxTransferClassInfo> listByUserIdAndClassId(Long userId, Long classId, Collection<Integer> status) {
        SingleSqlBuilder<TxTransferClassInfo> sqlBuilder = this.createSqlBuilder();
        sqlBuilder.eq("userId", userId);
        sqlBuilder.eq("transferOutClassId", classId);
        if (status != null && status.size() > 0) {
            sqlBuilder.in("status", status);
        }
        return queryList(sqlBuilder);
    }

    @Override
    public List<TxTransferClassInfo> listByUserIdsAndClassId(Collection<Long> userIds, Long classId, Collection<Integer> status) {
        SingleSqlBuilder<TxTransferClassInfo> sqlBuilder = this.createSqlBuilder();
        sqlBuilder.in("userId", userIds);
        sqlBuilder.eq("transferOutClassId", classId);
        if (status != null && status.size() > 0) {
            sqlBuilder.in("status", status);
        }
        return queryList(sqlBuilder);
    }
}

