package com.baijia.tianxiao.dal.finance.dao.impl;

import java.util.List;

import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.finance.dao.TxStudentFinanceRecordDao;
import com.baijia.tianxiao.dal.finance.po.TxStudentFinanceRecord;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;

import lombok.extern.slf4j.Slf4j;

/**
 * Created with IntelliJ IDEA. User: Victor Weng Date: 16/7/7 Time: 下午7:00 To change this template use File | Settings |
 * File Templates.
 */
@Repository
@Slf4j
public class TxStudentFinanceRecordDaoImpl extends JdbcTemplateDaoSupport<TxStudentFinanceRecord>
    implements TxStudentFinanceRecordDao {

    @Override
    public List<TxStudentFinanceRecord> findTxStudentFinanceRecords(Long orgId, Long studentId, PageDto pageDto) {
        SingleSqlBuilder<TxStudentFinanceRecord> builder = this.createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("studentId", studentId);
        builder.eq("isShow", 0);
        builder.desc("updateTime");
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        List<TxStudentFinanceRecord> queryList = this.queryList(builder);
        return GenericsUtils.isNullOrEmpty(queryList) ? GenericsUtils.<TxStudentFinanceRecord> emptyList() : queryList;
    }

}
