package com.baijia.tianxiao.dal.finance.dao.impl;

import com.baijia.tianxiao.dal.finance.dao.TxStudentFinanceAccountDao;
import com.baijia.tianxiao.dal.finance.po.TxStudentFinanceAccount;
import com.baijia.tianxiao.dal.finance.po.TxStudentFinanceAccountDto;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;


/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/7/7
 * Time: 下午7:00
 * To change this template use File | Settings | File Templates.
 */
@Repository
@Slf4j
public class TxStudentFinanceAccountDaoImpl extends JdbcTemplateDaoSupport<TxStudentFinanceAccount> implements TxStudentFinanceAccountDao {

    @Override
    public TxStudentFinanceAccount getFinanceAccount(Long orgId, Long studentId) {
        SingleSqlBuilder<TxStudentFinanceAccount> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("studentId", studentId);
        builder.setMaxSize(1);
        return uniqueResult(builder);
    }

    @Override
    public List<TxStudentFinanceAccount> getFinanceAccount(Long orgId, PageDto pageDto) {
        SingleSqlBuilder<TxStudentFinanceAccount> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        return this.queryList(builder);
    }

    @Override
    public List<TxStudentFinanceAccountDto> searchByStudentAccount(Long orgId, String key, PageDto page) {
        StringBuilder sb = new StringBuilder();
        sb.append("select os.id,os.student_name,os.mobile,sfa.balance from yunying.org_students os left join ");
        sb.append(" yunying.tx_student_finance_account sfa on os.id = sfa.student_id where os.del_status=0 and os.org_id=:orgId ");

        HashMap params = Maps.newHashMap();
        params.put("orgId", orgId);
        if (key != null && !key.equals("")) {
            sb.append(" and (os.student_name like :key or os.mobile like :key) ");
            params.put("key", "%"+key+"%");
        }
        sb.append(" order by  os.update_time desc");
        if (page != null) {
            params.put("offset", (page.getPageNum() - 1) * page.getPageSize());
            params.put("size", page.getPageSize());
            sb.append(" limit :offset,:size");
        }
        log.debug("searchByStudentAccount= sql+:{},params={}", sb.toString(), params);
        final List<TxStudentFinanceAccountDto> result = Lists.newArrayList();

        this.getNamedJdbcTemplate().query(sb.toString(), params, new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet resultSet) throws SQLException {
                TxStudentFinanceAccountDto studentFinanceAccount = new TxStudentFinanceAccountDto();
                studentFinanceAccount.setStudentId(resultSet.getLong("id"));
                studentFinanceAccount.setStudentName(resultSet.getString("student_name"));
                studentFinanceAccount.setStudentBalance(Double.valueOf(resultSet.getLong("balance")) / 100);
                studentFinanceAccount.setStudentMobile(resultSet.getString("mobile"));
                log.info("searchByStudentAccount dto ={}", studentFinanceAccount);
                result.add(studentFinanceAccount);
            }
        });
        log.debug("searchByStudentAccount= sql+:{},params={},result={}", sb.toString(), params, result);
        return result;
    }

    @Override
    public Integer countByStudentAccount(Long orgId, String key) {
        StringBuilder sb = new StringBuilder();
        sb.append("select count(1) from yunying.org_students os left join ");
        sb.append(" yunying.tx_student_finance_account sfa on os.id = sfa.student_id where os.del_status=0 and os.org_id=:orgId ");

        HashMap params = Maps.newHashMap();
        params.put("orgId", orgId);
        if (key != null && !key.equals("")) {
            sb.append(" and (os.student_name like :key or os.mobile like :key) ");
            params.put("key", "%"+key+"%");
        }

        log.debug("searchByStudentAccount= sql+:{},params={}", sb.toString(), params);
        return this.getNamedJdbcTemplate().queryForObject(sb.toString(), params, Integer.class);
    }

    @Override
    public void updateStudentAccountPrice(Long id, Long changeBalance, Long changeFreeze) {
        StringBuilder sb = new StringBuilder();
        sb.append("update yunying.tx_student_finance_account set balance=balance+:changeBalance,freeze_money=freeze_money+:changeFreeze,update_time=now() where id = :id ");

        HashMap params = Maps.newHashMap();
        params.put("id", id);
        params.put("changeBalance", changeBalance);
        params.put("changeFreeze", changeFreeze);

        this.getNamedJdbcTemplate().update(sb.toString(), params);
    }
}
