package com.baijia.tianxiao.dal.finance.dao.impl;

import com.baijia.tianxiao.dal.finance.dao.CwDrawcashPurchaseDao;
import com.baijia.tianxiao.dal.finance.po.CWDrawcashPurchase;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * Created with IntelliJ IDEA. User: Victor Weng Date: 16/8/24 Time: 下午2:34 To change this template use File | Settings
 * | File Templates.
 */
@Repository
public class CwDrawcashPurchaseDaoImpl extends JdbcTemplateDaoSupport<CWDrawcashPurchase>
    implements CwDrawcashPurchaseDao {

    @Override
    public List<CWDrawcashPurchase> listDrawcashing(Long orgId, PageDto pageDto, String...queryProps) {
        SingleSqlBuilder<CWDrawcashPurchase> builder = createSqlBuilder(queryProps);
        builder.eq("userId", orgId);

        List<Integer> userTypes = Lists.newArrayList();
        userTypes.add(3);// 机构
        userTypes.add(8);// 天校
        builder.in("userType", userTypes);

        List<Integer> status = Lists.newArrayList();
        status.add(2);// 处理成功
        status.add(3);// 失败
        status.add(5);// 驳回
        builder.notin("status", status);

        if (pageDto!=null){
            builder.setPage(pageDto);
        }

        builder.desc("updateTime");
        return queryList(builder);
    }

    @Override
    public List<CWDrawcashPurchase> listAll(Long orgId,PageDto pageDto, String...queryProps) {
        SingleSqlBuilder<CWDrawcashPurchase> builder = createSqlBuilder(queryProps);
        builder.eq("userId", orgId);

        List<Integer> userTypes = Lists.newArrayList();
        userTypes.add(3);// 机构
        userTypes.add(8);// 天校
        builder.in("userType", userTypes);
        if (pageDto!=null){
            builder.setPage(pageDto);
        }

        builder.desc("updateTime");
        return queryList(builder);
    }
}
