package com.baijia.tianxiao.dal.finance.dao;

import com.baijia.tianxiao.dal.finance.po.TxTransferClassRecord;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by wengshengli on 2017/4/21.
 */
public interface TxTransferClassRecordDao extends CommonDao<TxTransferClassRecord> {

    List<TxTransferClassRecord> getOrgTransferRefundListByMinId(Long minId, Date lastDate, int maxSize,
                                                                String... queryProps);

    List<TxTransferClassRecord> groupByTransferNumber(Long outPurchaseId,Long classId);

    TxTransferClassRecord sumByPurchases(List<Long> outPurchaseIds, Long transferOutClassId);

    List<TxTransferClassRecord> listByInPurchaseId(Long inPurchaseId);
    
    List<TxTransferClassRecord> listByInPurchaseIds(Collection<Long> inPurchaseIds);

    List<TxTransferClassRecord> listByUserClass(Long userId, Long classId, Long outPurchaseId, Integer status);

    List<TxTransferClassRecord> listByTransferNumber(Long transferNumber);

    List<TxTransferClassRecord> listByTransferNumbers(Collection<Long> transferNumbers);

    List<TxTransferClassRecord> listByOutPurchaseId(Long transferNumber, Long outPurchaseId);
    
    List<TxTransferClassRecord> listByOutPurchaseIds(Collection<Long> outPurchaseIds, String... props);

    int updateRefundType(Long transferClassNumber, Integer refundType);

    int updateStatus(Long transferClassNumber, Integer status);

    /**
     * 根据订单统计订单与班级的数据,注意:purchaseID不唯一,一次可以报多个班级,需要用订单ID和班级ID唯一确认
     * @param purchaseIds
     * @return 返回的KEY为purchaseId_classId
     */
    public Map<String, TxTransferClassRecord> groupByPurchaseIds(Collection<Long> purchaseIds,Collection<Integer> status);

}
