/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.export.po;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import lombok.Data;

/**
 * @author gaodan
 * @createdate 2016年6月29日
* @desc 
 */

@Data
@Entity(dataSourceBeanName = "cdbDataSource")
@Table(name = "tx_logstat_event", catalog = "db_statistics")
public class TXLogstatEvent {
    @Id
    @GeneratedValue
    @Column
    private long id;
    
    @Column
    private Long eventTime;
    
    @Column
    private String statisticId;
    
    @Column
    private Long userNumber;   //机构orgNumber
    
    @Column
    private Long userId;     //机构orgId
    
    @Column
    private Long roleId;      //用户角色id  orgNumber或者cascadeId
    
    @Column
    private Integer roleType;   //机构角色 参考MsgUserRole
    
    @Column
    private Integer dataAccountType;   //机构帐号类型
    
    @Column
    private String mobile;    //
    
    @Column
    private String appTerminal;   //app终端类型,android,ios
    
    @Column
    private String deviceId;  //设备ID,设备唯一标识
    
    @Column
    private String appTest;   //是否是测试版 0表示线上
    
    @Column
    private String pt;   //分片参数,日期  20160628
    
    @Column
    private String hour;  //分片参数
}
