/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.export.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.export.dao.TXLogStatEventDao;
import com.baijia.tianxiao.dal.export.dto.LogStatisticDto;
import com.baijia.tianxiao.dal.export.po.TXLogstatEvent;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;

/**
 * @author gaodan
 * @createdate 2016年6月29日
 * @desc
 */
@Repository
public class TXLogStatEventDaoImpl extends JdbcTemplateDaoSupport<TXLogstatEvent> implements TXLogStatEventDao {

    @Override
    public Map<Long, LogStatisticDto> getLogStatisticDtoMap(List<Long> orgIds, Date startTime, Date endTime) {
        List<List<Long>> splitList = GenericsUtils.splitList(orgIds, 10);
        final Map<Long, LogStatisticDto> map = new HashMap<>();
        for (List<Long> subOrgIds : splitList) {
            Map<String, Object> param = new HashMap<>();
            param.put("orgIds", subOrgIds);

            String sql =
                "select user_id as org_id, count(distinct role_id) as login_account_total, count(distinct device_id) as login_device_total"
                    + " from db_statistics.tx_logstat_event where user_id is not null and user_id in(:orgIds) and role_id !=0 and role_type != 0 ";

            if (startTime != null) {
                sql += "and pt between date_format(:startTime,'%Y%m%d') and date_format(:endTime,'%Y%m%d') ";
                param.put("startTime", startTime);
                param.put("endTime", endTime);
            }

            sql += " group by user_id";

            return this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<Long, LogStatisticDto>>() {
                @Override
                public Map<Long, LogStatisticDto> extractData(ResultSet rs) throws SQLException, DataAccessException {
                    while (rs.next()) {
                        Integer loginAccountTotal = rs.getInt("login_account_total");
                        Integer loginDeviceTotal = rs.getInt("login_device_total");
                        Long orgId = rs.getLong("org_id");
                        LogStatisticDto dto = new LogStatisticDto();
                        dto.setLoginAccountTotal(loginAccountTotal);
                        dto.setLoginDeviceTotal(loginDeviceTotal);
                        map.put(orgId, dto);
                    }
                    return null;
                }
            });
        }
        return map;
    }

    @Override
    public Map<Long, Integer> getOrgOpenTotalMap(List<Long> orgIds, Date startTime, Date endTime) {
        Map<String, Object> param = new HashMap<>();
        param.put("orgIds", orgIds);
        String sql = "select user_id as org_id, count(1) as org_open_total from db_statistics.tx_logstat_event where "
            + "user_id is not null and statistic_id in ('tianxiao_app_start','tianxiao_app_foreground') and role_id !=0 and role_type != 0 ";

        if (startTime != null) {
            sql += "and pt between date_format(:startTime,'%Y%m%d') and date_format(:endTime,'%Y%m%d') ";
            param.put("startTime", startTime);
            param.put("endTime", endTime);
        }

        sql += " group by user_id";

        return this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<Long, Integer>>() {

            @Override
            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                Map<Long, Integer> map = new HashMap<>();
                while (rs.next()) {
                    Integer count = rs.getInt("org_open_total");
                    Long orgId = rs.getLong("org_id");
                    map.put(orgId, count);
                }
                return map;
            }
        });
    }

}
