
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2015 All Rights Reserved.
 */
    
package com.baijia.tianxiao.dal.course.dao.impl;

import java.util.Collection;
import java.util.List;

import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.course.dao.OrgRecommendCourseDao;
import com.baijia.tianxiao.dal.course.po.OrgCourseGroupRelate;
import com.baijia.tianxiao.dal.course.po.OrgRecommendCourse;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;


/**
 * @title OrgRecommendCourseDaoImpl
 * @desc TODO 
 * @author zhangbing
 * @date 2015年12月8日
 * @version 1.0
 */
@Repository("orgRecommendCourseDao")
public class OrgRecommendCourseDaoImpl extends JdbcTemplateDaoSupport<OrgRecommendCourse> implements OrgRecommendCourseDao {

    /**
     * @param entityClass
     */
    public OrgRecommendCourseDaoImpl() {
        super(OrgRecommendCourse.class);
    }

    @Override
    public List<OrgRecommendCourse> getRecommendCourseList(Integer orgId) {
        SingleSqlBuilder<OrgRecommendCourse> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("isDeleted", DeleteStatus.NORMAL.getValue());
        builder.desc("displayOrder");
        return queryList(builder);
    }

    @Override
    public void removeRecommendCourse(OrgRecommendCourse recommendCourse) {
        update(recommendCourse, new String[]{"isDeleted", "updateTime"});
    }

    @Override
    public OrgRecommendCourse getOrgRecommendCourse(Integer orgId, Long courseId, Integer courseType) {
        SingleSqlBuilder<OrgRecommendCourse> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("courseid", courseId);
        builder.eq("courseType", courseType);
        builder.eq("isDeleted", DeleteStatus.NORMAL.getValue());
        return uniqueResult(builder);
    }

    @Override
    public int getOrgRecommendCourseCount(Integer orgId) {
        SingleSqlBuilder<OrgRecommendCourse> builder = createSqlBuilder();
        builder.count("id");
        builder.eq("orgId", orgId);
        builder.eq("isDeleted", DeleteStatus.NORMAL.getValue());
        return queryForObject(builder, Integer.class);
    }

    @Override
    public int getMaxDisplayOrderByExcludeIds(Long orgId, Collection<Long> excludeIds) {
        SingleSqlBuilder<OrgRecommendCourse> builder = createSqlBuilder();
        builder.max("displayOrder");
        builder.eq("orgId", orgId);
        builder.eq("isDeleted", DeleteStatus.NORMAL.getValue());
        builder.notin("courseid", excludeIds);
        Integer count = queryForObject(builder, Integer.class);
        
        return count == null ? 0 : count;
    }
}

    