/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.course.dao.impl;

import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupDao;
import com.baijia.tianxiao.dal.course.po.OrgCourseGroup;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author zhangbing
 * @version 1.0
 * @title OrgCourseGroupDaoImpl
 * @desc TODO
 * @date 2015年12月8日
 */
@Repository("orgCourseGroupDao")
@Slf4j
public class OrgCourseGroupDaoImpl extends JdbcTemplateDaoSupport<OrgCourseGroup> implements OrgCourseGroupDao {

    public OrgCourseGroupDaoImpl() {
        super(OrgCourseGroup.class);
    }

    /**
     * 查询机构课程分类列表
     */
    @Override
    public List<OrgCourseGroup> getOrgCourseGroupList(Integer orgId) {
        SingleSqlBuilder<OrgCourseGroup> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("isDeleted", DeleteStatus.NORMAL.getValue());
        builder.desc("displayOrder");
        return queryList(builder);
    }

    @Override
    public List<Integer> getOrgCourseGroupIdList(Integer orgId) {
        SingleSqlBuilder<OrgCourseGroup> builder = createSqlBuilder("id");
        builder.eq("orgId", orgId);
        builder.eq("isDeleted", DeleteStatus.NORMAL.getValue());
        builder.desc("displayOrder");
        return this.queryForList(builder, Integer.class);
    }

    @Override
    public Map<Integer, Integer> getCourseCountMap(Integer orgId, Collection<Long> courseIds,
                                                   Collection<Integer> groupIds) {

        if (CollectionUtils.isEmpty(groupIds)) {
            return Collections.emptyMap();
        }
        if (CollectionUtils.isEmpty(courseIds)) {
            return Collections.emptyMap();
        }

        String sql =
                "select course_group_id as groupId, count(course_id) as courseCnt from yunying.org_course_group_relate where is_deleted=0 and course_type=4 and course_group_id in(:groupIds) and course_id in (:courseIds) group by course_group_id";
        Map<String, Object> paramMap = Maps.newHashMap();
        paramMap.put("groupIds", groupIds);
        paramMap.put("courseIds", courseIds);
        final Map<Integer, Integer> map = Maps.newHashMap();
        log.debug("sql={},param={}", sql, paramMap);
        this.getNamedJdbcTemplate().query(sql, paramMap, new RowCallbackHandler() {

            @Override
            public void processRow(ResultSet rs) throws SQLException {

                map.put(rs.getInt("groupId"), rs.getInt("courseCnt"));

            }

        });

        log.debug("result={}", map);
        return map;
    }

    /**
     * 查询机构分类名称
     */
    @Override
    public List<String> getDistinctSubject(Integer orgId, PageDto pageDto) {
        String sql =
                "select distinct name from yunying.org_course_group_relate oc,"
                        + "yunying.org_course_group og where oc.course_group_id=og.id and og.org_id=? and oc.is_deleted=0 order by og.display_order desc limit ?, ?";
        List<String> names =
                this.getNamedJdbcTemplate().getJdbcOperations()
                        .query(sql, new Object[]{orgId, pageDto.firstNum(), pageDto.getPageSize()}, new RowMapper<String>() {

                            @Override
                            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                                return rs.getString("name");
                            }
                        });
        return names;
    }

    @Override
    public int countByName(Integer orgId, String name) {
        SingleSqlBuilder<OrgCourseGroup> builder = createSqlBuilder();
        builder.eq("name", name);
        builder.eq("orgId", orgId);
        builder.eq("isDeleted", DeleteStatus.NORMAL.getValue());
        builder.count("id");
        return queryForObject(builder, Integer.class);

    }

    @Override
    public void refreshOrgCourseGroup(Long orgId, Long id) {
        StringBuilder sb = new StringBuilder("update yunying.org_course_group set is_deleted =1 where id > :id and  org_id = :orgId");
        Map param = Maps.newHashMap();
        param.put("orgId", orgId);
        param.put("id", id);
        log.info("refreshOrgCourseGroup sql={},params={}", sb.toString(), param);
        this.getNamedJdbcTemplate().update(sb.toString(), param);
    }

    /**
     * 查询机构课程分类列表
     */
    @Override
    public List<OrgCourseGroup> getOrgCourseGroupList(Integer orgId,String key,PageDto pageDto) {
        SingleSqlBuilder<OrgCourseGroup> builder = createSqlBuilder();
        if(StringUtils.isNotBlank(key)){
            builder.or(Expressions.like("name", key, MatchMode.ANYWHERE));
        }
        builder.eq("orgId", orgId);
        builder.eq("isDeleted", DeleteStatus.NORMAL.getValue());
        builder.setPage(pageDto);
        builder.desc("displayOrder");
        return queryList(builder);
    }
}
