
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2015 All Rights Reserved.
 */
    
package com.baijia.tianxiao.dal.course.dao;

import java.util.Collection;
import java.util.List;

import com.baijia.tianxiao.dal.course.po.OrgRecommendCourse;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;


/**
 * @title OrgRecommendCourseDao
 * @desc TODO 
 * @author zhangbing
 * @date 2015年12月8日
 * @version 1.0
 */

public interface OrgRecommendCourseDao extends CommonDao<OrgRecommendCourse> {

    /**
     * 获取机构推荐课程列表
     * @param orgId
     * @return
     */
    public List<OrgRecommendCourse> getRecommendCourseList(Integer orgId);
    
    /**
     * 查询机构推荐课程
     * @param orgId
     * @return
     */
    public OrgRecommendCourse getOrgRecommendCourse(Integer orgId, Long courseId, Integer courseType);
    
    /**
     * 删除推荐课程
     * @param orgId
     * @param courseId
     */
    public void removeRecommendCourse(OrgRecommendCourse recommendCourse);
    
    /**
     * 查询机构已推荐课程数
     * @param orgId
     * @return
     */
    public int getOrgRecommendCourseCount(Integer orgId);
    
    /**
     * 获取推荐课程排序最大ID
     * @param orgId
     * @param excludeIds
     * @return
     */
    public int getMaxDisplayOrderByExcludeIds(Long orgId, Collection<Long> excludeIds);

}

    