package com.baijia.tianxiao.dal.course.dao;

import com.baijia.tianxiao.dal.course.po.OrgCourseGroupRelate;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 
 * @title OrgCourseGroupRelateDao
 * @desc TODO
 * @author zhangbing
 * @date 2015年12月13日
 * @version 1.0
 */
public interface OrgCourseGroupRelateDao extends CommonDao<OrgCourseGroupRelate> {

    /**
     * 查询机构自定义分类课程
     */
    public List<OrgCourseGroupRelate> getOrgCourseGroup(Integer orgId, PageDto pageDto);

    /**
     * 查询自定义分类下3810、班课课程ID集合
     * 
     * @param courseGroupId 课程分类ID
     * @return
     */
    public List<Long> getCourseIdsByGroup(Integer courseGroupId, Integer courseType);

    /**
     * 根据groupIds返回课程
     * 
     * @author shizuwei
     * @param courseType
     * @return
     */
    public Collection<Long> getCourseIdsByGroups(Collection<Integer> courseGroupIds, Integer courseType);

    /**
     * 根据课程分类ID、课程类型、课程ID查询分类课程
     * 
     * @param courseGroupId 课程分类ID
     * @param courseType 课程分类
     * @param courseId 课程ID
     * @return
     */
    public OrgCourseGroupRelate getCourseGroupByCourseId(Integer courseGroupId, Integer courseType, Long courseId);

    /**
     * 获取指定分类下排除${excludeIds}后最大的displayOrder
     * 
     * @param courseGroupId 分类ID
     * @param excludeIds 排除列表
     * @return
     */
    public int getMaxDisplayOrderByExcludeIds(Integer courseGroupId, Collection<Long> excludeIds);

    List<OrgCourseGroupRelate> getGroupByCourseId(Long courseId, Integer courseType);

    List<Integer> getGroupIdByCourseId(Long courseId, Integer courseType);

    void batchAddWeike(Long groupId, Collection<Long> courseIds);

    void deleteGroupOfCourse(Long courseId, Collection<Integer> groupIds, Integer courseType);

    boolean isRecommendTeacher(long teacherId);

    Map<Long, Integer> isRecommendTeacher(Collection<Long> teacherIds);

    List<OrgCourseGroupRelate> getCourseGroupRelateByGroupIds(List<Integer> ids, int code);

    List<OrgCourseGroupRelate> getCourseGroupRelateByCourseIds(List<Integer> ids, int courseType);

    /**
     * 获取<课程id,分类ids>
     * @param courseIds
     * @return
     */
    Map<Long, Set<Integer>> getCourseGroupMap(Collection<Long> courseIds);
}
