package com.baijia.tianxiao.dal.callservice.po;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import java.util.Date;

import lombok.Data;


/**   
 * @title       : CallRecord 
 * @description : 天校 机构账号和咨询用户之间的 通话记录
 * @author      : zhenyujian
 * @date        : 2016年5月31日 下午11:46:06 
 */
@Data
@Table(catalog = "yunying", name = "callservice_consult_call_record")
@Entity
public class ConsultCallRecord {

    @Id
    @GeneratedValue
    private Long id;
    
    @Column(name = "org_id")
    private Long orgId;//机构ID
    
    @Column(name = "org_phone_number")
    private String orgPhoneNumber;//机构账号电话
    
    @Column(name = "consulter_id")
    private Long consulterId;//咨询用户表id
    
    @Column(name = "org_student_id")
    private Long orgStudentId;//学员id
    
    @Column(name = "consulter_phone_number")
    private String consulterPhoneNumber;//咨询用户电话
    
    @Column(name = "call_status")
    private Integer callStatus;//接听状态  见CallServiceCdrStatus
    
    @Column(name = "is_call_by_org")
    private Integer isCallByOrg;//是否是机构主动拨出
    
    @Column(name = "during_time")
    private Integer duringTime;//通话时长 单位秒
    
    @Column(name = "storage_id")
    private Long storageId;//通话文件id

    @Column(name = "create_time")
    private Date createTime;// 记录创建时间
    
    @Column(name = "update_time")
    private Date updateTime;// 记录更新时间
    
    @Column(name = "source")
    private Integer source; // ConsultCallRecordSource
    
    @Column(name = "source_id")
    private Long sourceId;
}
