package com.baijia.tianxiao.dal.callservice.po;

import java.util.Date;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import lombok.Data;

@Entity
@Data
@Table(catalog = "yunying", name = "callservice_dial_back")
public class CallServiceDialBack {
    
    @Id
    @GeneratedValue
    private Long id;
    @Column(name = "from_mobile")
    private String fromMobile;
    @Column(name = "to_mobile")
    private String toMobile;
    @Column(name = "start")
    private Date start;
    @Column(name = "call_start")
    private Date callStart;
    @Column(name = "call_end")
    private Date callEnd;
    @Column(name = "duration")
    private int duration; // 持续通话时间[冗余]
    @Column(name = "unique_id")
    private String uniqueId; // 天润中心的唯一id
    @Column(name = "customer_area_code")
    private String customerAreaCode; // 呼叫号码所在的区号
    @Column(name = "call_type")
    private Integer callType;
    @Column(name = "bridge_cno")
    private String bridgeCno; // 接听的坐席号
    @Column(name = "cs_role_id")
    private Integer csRoleId; // 专员id
    @Column(name = "cdr_status")
    private Integer cdrStatus;// cdr的状态值

    /**
     * 
     * 1：留言 2：咨询 3：转移 4：三方5：传真接收6：会议7：交互8：AMD 9：已进入IVR 10：未进入IVR 11：队列中放弃12：队列中溢出13：预约
     */
    @Column(name = "cdr_mark")
    private Integer cdrMark;

}
