/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.callservice.dao.impl;

import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.callservice.dao.TX400PhoneDao;
import com.baijia.tianxiao.dal.callservice.po.TX400Phone;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import java.util.Map;

/**
 * @title TX400PhoneDaoImpl
 * @desc O(∩_∩)O~ 
 * @author caoliang
 * @date 2016年6月24日
 * @version 1.0
 */
@Repository
public class TX400PhoneDaoImpl extends JdbcTemplateDaoSupport<TX400Phone> implements TX400PhoneDao {

    public static final Map<Integer, String> NO_400_ORGMAP = Maps.newHashMap();
    static {
        NO_400_ORGMAP.put(70677, "075722663200");
        NO_400_ORGMAP.put(71107, "075726611071");
        NO_400_ORGMAP.put(71108, "075728918688");
        NO_400_ORGMAP.put(70991, "075781068327");
        NO_400_ORGMAP.put(45772, "075783208355");
        NO_400_ORGMAP.put(71909, "075728909716");
    }

    public TX400PhoneDaoImpl() {
        super(TX400Phone.class);
    }

    @Override
    public TX400Phone getBy400Phone(String _400Phone) {
        SingleSqlBuilder<TX400Phone> builder = createSqlBuilder();
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        builder.eq("phone400", _400Phone);
        return uniqueResult(builder);
    }

    @Override
    public TX400Phone getByTransPhone(String transPhone) {
        SingleSqlBuilder<TX400Phone> builder = createSqlBuilder();
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        builder.eq("transPhone", transPhone);
        return uniqueResult(builder);
    }

    @Override
    public TX400Phone getByOrgId(Integer orgId) {
        SingleSqlBuilder<TX400Phone> builder = createSqlBuilder();
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        builder.eq("orgId", orgId);
        return uniqueResult(builder);
            
    }
}
