/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.callservice.dao.impl;

import com.baijia.tianxiao.dal.callservice.dao.OrgPushCallInfoDao;
import com.baijia.tianxiao.dal.callservice.po.OrgPushCallInfo;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.base.Preconditions;

import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @title OrgPushCallInfoDaoImpl
 * @desc TODO
 * @author cxm
 * @date 2015年12月5日
 * @version 1.0
 */
@Repository
public class OrgPushCallInfoDaoImpl extends JdbcTemplateDaoSupport<OrgPushCallInfo> implements OrgPushCallInfoDao {

    public OrgPushCallInfoDaoImpl() {
        super(OrgPushCallInfo.class);
    }

    @Override
    public List<OrgPushCallInfo> getCallInfoByMinId(Long id, Date time, int maxSize) {
        Preconditions.checkArgument(maxSize > 0, "max size is illegal");
        SingleSqlBuilder<OrgPushCallInfo> builder = createSqlBuilder();
        if (id == null) {
            if (time == null) {
                time = new Date();
            }
            builder.gt("startTime", time);
        } else {
            builder.gt("id", id);
        }
        builder.ne("extention", "");
        builder.asc("startTime");
        builder.setMaxSize(maxSize);
        return queryList(builder);
    }

    
    @Override
	public List<OrgPushCallInfo> page(Long minId, PageDto pageDto) {
        
        final List<OrgPushCallInfo> list = new ArrayList<OrgPushCallInfo>();

        StringBuilder builder = new StringBuilder();
        builder.append("SELECT * FROM yunying.callservice_org_call_record WHERE 1=1");
        if (minId!=null && minId!=0) {
            builder.append(" AND id>:minId");
        }

        if (pageDto != null) {
            builder.append(" LIMIT :start,:size");
        }

        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("minId", minId);
        params.put("start", pageDto.firstNum());
        params.put("size", pageDto.getPageSize());

        template.query(builder.toString(), params, new RowMapper<Integer>() {
        	OrgPushCallInfo info;

            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
            	info = new OrgPushCallInfo();
            	info.setConnectedNumber( rs.getString("connected_number") );
            	info.setConnectedTime( rs.getTimestamp("connected_time") );
            	info.setCustomerNumber( rs.getString("customer_number") );
            	info.setDuringTime( rs.getInt("during_time") );
            	info.setExtention( rs.getString("extention") );
            	info.setHangUpTime( rs.getTimestamp("hang_up_time") );
            	info.setId( rs.getLong("id") );
            	info.setRecordFile( rs.getString("record_file") );
            	info.setStartTime( rs.getTimestamp("start_time") );
            	info.setStatus( rs.getInt("status") );
            	info.setStorageId( rs.getLong("storage_id") );
            	info.setUniqueId( rs.getString("unique_id") );
                
                list.add(info);
                return 1;
            }
        });

        return list;
	}
}
