package com.baijia.tianxiao.dal.callservice.dao.impl;

import com.baijia.tianxiao.dal.callservice.dao.CallServiceStatisticsDao;
import com.baijia.tianxiao.dal.callservice.po.CallServiceStatistics;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.springframework.stereotype.Repository;

import java.util.Date;


@Repository("callServiceStatisticsDao")
public class CallServiceStatisticsDaoImpl extends JdbcTemplateDaoSupport<CallServiceStatistics> implements CallServiceStatisticsDao {

    public CallServiceStatisticsDaoImpl() {
        super(CallServiceStatistics.class);
    }
    
    @Override
    public CallServiceStatistics getStatistics(Long courseNum, Date day) {
        SingleSqlBuilder<CallServiceStatistics> builder = createSqlBuilder();
        builder.eq("courseNumber", courseNum);
        builder.eq("day", day);
        return uniqueResult(builder);
    }

    @Override
    public int getPeroidStatistics(Long courseNum, Date startDay, Date endDay) {
        SingleSqlBuilder<CallServiceStatistics> builder = createSqlBuilder();
        builder.sum("totalCount");
        builder.eq("courseNumber", courseNum);
        builder.ge("day", startDay);
        builder.le("day", endDay);
        Integer count = this.queryForObject(builder, Integer.class);
        if(count == null){
            return 0;
        }
        return count;
    }

    @Override
    public int getAllStatistics(Long courseNum) {
        SingleSqlBuilder<CallServiceStatistics> builder = createSqlBuilder();
        builder.sum("totalCount");
        builder.eq("courseNumber", courseNum);
        Integer count = this.queryForObject(builder, Integer.class);
        if(count == null){
            return 0;
        }
        return count;
    }
    
}
