/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.callservice.dao;

import java.util.Date;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.advisory.dao.dto.CallStatisticDto;
import com.baijia.tianxiao.dal.callservice.constant.PartyCallType;
import com.baijia.tianxiao.dal.callservice.po.CallServiceInfo;
import com.baijia.tianxiao.dal.org.po.OrgGroupMsg;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

/**
 * @title CallServiceInfoDao
 * @desc TODO
 * @author cxm
 * @date 2015年12月5日
 * @version 1.0
 */
public interface CallServiceInfoDao extends CommonDao<CallServiceInfo> {

    /**
     * 查询指定号码呼叫第三方的ID的次数
     *
     * @param mobile
     * @param callParty
     * @param callType
     * @return
     */
    Map<String, Object> queryCallCountAndTime(String mobile, Long callParty, PartyCallType callType);

    public Integer getTotalDurationByOrgId(Integer orgId);

    List<CallServiceInfo> listCallServiceInfoDesc(Integer orgId, String mobile, PageDto pageDto);

    List<CallServiceInfo> page(Long minId, PageDto pageDto);

    public Map<Long, CallStatisticDto> getTotalDurationAndCount(Date startTime, Date endTime, List<Long> orgIds);


}