package com.baijia.tianxiao.dal.callservice.constant;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * @title PartyCallType
 * @desc S表示学生,T表示老师, O 表示机构
 * @author cxm
 * @date 2015年6月18日
 * @version 1.0
 */
public enum PartyCallType {
    S2T(0), // 学生给老师打电话
    T2S(1), // 老师给学生打电话
    S2O(2), // 学生打机构
    T2O(3), // 老师打机构
    O2S(4), // 机构打学生
    O2T(5), // 机构打老师

    T2T(6), // 老师打老师
    O2O(7), // 机构打机构
    S2S(8), // 学生打学生
    UNKNOW(10), // 未知

    VIDEO_BROADCAST(11), // 视频直播
    ;

    private int code;

    private static Map<String, PartyCallType> callTypeMaping = new HashMap<String, PartyCallType>();

    /**
     * 学生主叫的类型
     */
    private static Set<PartyCallType> studentSubsriberType = new HashSet<PartyCallType>();
    /**
     * 学生被叫的类型
     */
    private static Set<PartyCallType> studentCalledType = new HashSet<PartyCallType>();

    private static Set<PartyCallType> teacherSubsriberType = new HashSet<PartyCallType>();
    private static Set<PartyCallType> teacherCalledType = new HashSet<PartyCallType>();

    private static Set<PartyCallType> orgSubsriberType = new HashSet<PartyCallType>();
    private static Set<PartyCallType> orgCalledType = new HashSet<PartyCallType>();

    private static Set<PartyCallType> orgType = new HashSet<PartyCallType>();

    private PartyCallType(Integer code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    static {
        for (PartyCallType type : PartyCallType.values()) {
            callTypeMaping.put(type.code + "", type);
            if (type.name().startsWith("S")) {
                studentSubsriberType.add(type);
            } else if (type.name().startsWith("T")) {
                teacherSubsriberType.add(type);
            } else if (type.name().startsWith("O")) {
                orgSubsriberType.add(type);
                orgType.add(type);
            }

            if (type.name().endsWith("S")) {
                studentCalledType.add(type);
            } else if (type.name().endsWith("T")) {
                teacherCalledType.add(type);
            } else if (type.name().endsWith("O")) {
                orgCalledType.add(type);
                orgType.add(type);
            }
        }
    }

    public static PartyCallType getCallTypeByCode(String codeStr) {
        return callTypeMaping.get(codeStr);
    }

    /**
     * @return the studentSubsriberType
     */
    public static Set<PartyCallType> getStudentSubsriberType() {
        return studentSubsriberType;
    }

    /**
     * @return the studentCalledType
     */
    public static Set<PartyCallType> getStudentCalledType() {
        return studentCalledType;
    }

    /**
     * @return the teacherSubsriberType
     */
    public static Set<PartyCallType> getTeacherSubsriberType() {
        return teacherSubsriberType;
    }

    /**
     * @return the teacherCalledType
     */
    public static Set<PartyCallType> getTeacherCalledType() {
        return teacherCalledType;
    }

    /**
     * @return the orgSubsriberType
     */
    public static Set<PartyCallType> getOrgSubsriberType() {
        return orgSubsriberType;
    }

    /**
     * @return the orgCalledType
     */
    public static Set<PartyCallType> getOrgCalledType() {
        return orgCalledType;
    }

    public static Set<PartyCallType> getOrgType() {
        return orgType;
    }

}
