/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.callservice.constant;

import java.util.Map;

import com.google.common.collect.Maps;

public enum ConsultCallRecordStatus {
	UNKNOWN(0, "未知"), CONNECTED(1, "接通"), LISTENER_UNCONNECT(2, "未接通"), CALL_UNCONNECT(10, "取消");

    private Integer code;
    private String msg;

    private ConsultCallRecordStatus(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private static Map<Integer, ConsultCallRecordStatus> map = Maps.newHashMap();

    private ConsultCallRecordStatus(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    static {
        for (ConsultCallRecordStatus at : ConsultCallRecordStatus.values()) {
            map.put(at.code, at);
        }
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public static ConsultCallRecordStatus getTypeByCode(Integer code) {
        return map.get(code.intValue());
    }

}
