/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.callservice.constant;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * @title CallServiceCdrStatus
 * @desc TODO
 * @author shanyu
 * @date 2015年12月9日
 * @version 1.0
 */

public enum CallServiceCdrStatus {
    // 电话接通状态, 1 接通 2 第二方未接通 10 第一方未接通

    CONNECTED(1, "接通"), LISTENER_UNCONNECT(2, "第二方未接通"), CALL_UNCONNECT(10, "第一方未接通");

    private Integer code;
    private String msg;

    private CallServiceCdrStatus(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private static Map<Integer, CallServiceCdrStatus> map = Maps.newHashMap();

    private CallServiceCdrStatus(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    static {
        for (CallServiceCdrStatus at : CallServiceCdrStatus.values()) {
            map.put(at.code, at);
        }
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public static CallServiceCdrStatus getTypeByCode(Integer code) {
    	if(code==null) return null;
        return map.get(code.intValue());
    }

}
