package com.baijia.tianxiao.dal.blackboard.po;

import java.io.Serializable;
import java.sql.Timestamp;
import lombok.Data;
import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

@Entity(name = "org_blackboard_info")
@Data
@Table(catalog = "yunying")
public class Blackboard implements Serializable {

    private static final long serialVersionUID = -2338761780077468775L;

    @Id
    @GeneratedValue
    private Long id;
    
    @Column(name = "storage_id")
    private int storageId;
    
    @Column(name = "org_id")
    private int orgId;
    
    //黑板报类型
    @Column(name = "bb_type")
    private int bbType;
    
    //内容类型
    @Column(name = "c_type")
    private int cType;
    
    //接受者类型
    @Column(name = "r_type")
    private int rType;
    
    //是否同步到结构主页
    @Column(name = "sync")
    private int sync;
    
    //是否同步到老师主页
    @Column(name = "tids")
    private String tids;
    
    //黑板报标题
    @Column(name = "title")
    private String title;
    
    //黑板报内容
    @Column(name = "content")
    private String content;
    
    //审核状态
    @Column(name = "auditstatus")
    private int auditstatus;
    
    //审核拒绝原因
    @Column(name = "reason")
    private String reason;
    
    //审核拒绝其他原因
    @Column(name = "other")
    private String other;
    
    //创建时间
    @Column(name = "create_time")
    private Timestamp createTime;
    
    //更新时间
    @Column(name = "update_time")
    private Timestamp updateTime;
    
    @Column(name = "isdel")
    private int isdel;
    
    //是否置顶0:置顶，1：不置顶
    @Column(name = "stick")
    private int stick;
    
    @Column(name = "qr_url")
    private String qrUrl;
    
    //课程对外暴露的编号
    @Column(name = "course_number")
    private Long courseNumber;
    
    //活动配置开关，默认关闭0:关闭，1:开启
    @Column(name = "switcher")
    private int switcher;
}
