
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.article.dao.impl;

import java.util.Collections;
import java.util.List;

import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.article.dao.BisChannelInfoDao;
import com.baijia.tianxiao.dal.article.po.BisChannelInfo;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Aug 10, 2016
 * @desc
 */
@Repository
public class BisChannelInfoDaoImpl extends JdbcTemplateDaoSupport<BisChannelInfo> implements BisChannelInfoDao {

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dal.article.dao.BisChannelInfoDao#listBisChannelInfos(java.util.List)
     */
    @Override
    public List<BisChannelInfo> listBisChannelInfos(List<String> channelNames) {
        if (GenericsUtils.isNullOrEmpty(channelNames)) {
            return Collections.emptyList();
        }
        SingleSqlBuilder<BisChannelInfo> createSqlBuilder = this.createSqlBuilder("id", "name", "parent");
        createSqlBuilder.in("name", channelNames);
        createSqlBuilder.eq("parentId", 0);
        createSqlBuilder.eq("deleteFlag", 0);
        return queryList(createSqlBuilder);
    }

    @Override
    public List<BisChannelInfo> listOtherBisChannelInfos(List<String> channelNames) {
        if (GenericsUtils.isNullOrEmpty(channelNames)) {
            return Collections.emptyList();
        }
        SingleSqlBuilder<BisChannelInfo> createSqlBuilder = this.createSqlBuilder("id", "name", "parent");
        createSqlBuilder.notin("name", channelNames);
        createSqlBuilder.eq("parentId", 0);
        createSqlBuilder.eq("deleteFlag", 0);
        return queryList(createSqlBuilder);
    }

}
