
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.article.dao.impl;

import java.util.Collections;
import java.util.List;

import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.article.dao.BisArticleInfoDao;
import com.baijia.tianxiao.dal.article.po.BisArticleInfo;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Aug 10, 2016
 * @desc
 */
@Repository
public class BisArticleInfoDaoImpl extends JdbcTemplateDaoSupport<BisArticleInfo> implements BisArticleInfoDao {

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dal.article.dao.BisArticleInfoDao#listBisArticleInfos(java.util.List)
     */
    @Override
    public List<BisArticleInfo> listBisArticleInfos(List<Long> articleIds) {
        if (GenericsUtils.isNullOrEmpty(articleIds)) {
            return Collections.emptyList();
        }
        SingleSqlBuilder<BisArticleInfo> createSqlBuilder = this.createSqlBuilder();
        createSqlBuilder.in("id", articleIds);
        createSqlBuilder.isNotNull("writer");
        createSqlBuilder.isNotNull("coverUrl");
        createSqlBuilder.ne("coverUrl", "");
        return this.queryList(createSqlBuilder);
    }

}
