/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.advisory.po;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import java.util.Date;

import lombok.Data;

/**
 * @title OrgCallRecorder
 * @desc TODO
 * @author shizuwei
 * @date 2015年10月30日
 * @version 1.0
 */
@Data
@Entity
@Table(name = "callservice_org_call_record", catalog = "yunying")
public class OrgCallRecorder {

    @Id
    @GeneratedValue
    private Long id;
    // 电话接通状态, 1 接通 2 未接通 3 分机号错误
    @Column(name = "status")
    private Integer status;

    @Column(name = "start_time")
    private Date startTime;
    // 接通时间
    @Column(name = "connected_time")
    private Date connectedTime;

    @Column(name = "hang_up_time")
    private Date hangUpTime;

    @Column(name = "during_time")
    private Integer duringTime;
    // 学生手机号码
    @Column(name = "customer_number")
    private String customerNumber;
    // 机构分机号
    @Column(name = "extention")
    private String extention;

    @Column(name = "connected_number")
    private String connectedNumber;

    @Column(name = "unique_id")
    private String uniqueId;

    @Column(name = "record_file")
    private String recordFile;

    @Column(name = "process_status")
    private Integer processStatus;

    @Column
    private Long storageId;

    // 虚拟字段
    private String studentName;
}
