/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.advisory.dao.impl;

import com.baijia.tianxiao.dal.advisory.dao.OrgStudentAdvisoryDao;
import com.baijia.tianxiao.dal.advisory.po.OrgStudentAdvisory;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

/**
 * @title OrgStudentAdvisoryDaoImpl
 * @desc TODO
 * @author cxm
 * @date 2015年9月22日
 * @version 1.0
 */
@Slf4j
@Repository
public class OrgStudentAdvisoryDaoImpl extends JdbcTemplateDaoSupport<OrgStudentAdvisory>
    implements OrgStudentAdvisoryDao {

    public OrgStudentAdvisoryDaoImpl() {
        super(OrgStudentAdvisory.class);
    }

    @Override
    public List<OrgStudentAdvisory> query(Date startTime, Date endTime, Collection<Long> orgIds, Integer advisoryType,
        String contenType, Collection<Integer> statuses, Collection<Long> studentIds, Collection<Integer> courseIds,
        PageDto page) {
        SingleSqlBuilder<OrgStudentAdvisory> builder = createSqlBuilder();
        if (startTime != null && endTime != null) {
            builder.between("createTime", startTime, endTime);
        }
        if (CollectionUtils.isNotEmpty(orgIds)) {
            builder.in("orgId", orgIds);
        }
        if (advisoryType != null) {
            if (advisoryType == 1) {
                builder.eq("advisoryType", advisoryType);
            } else if (advisoryType == 0) {
                builder.eq("advisoryType", advisoryType);
                builder.eq("contentType", contenType);
            } else {
                builder.eq("contentType", contenType);
            }
        }
        if (CollectionUtils.isNotEmpty(statuses)) {
            builder.in("status", statuses);
        }
        if (CollectionUtils.isNotEmpty(studentIds)) {
            if (CollectionUtils.isNotEmpty(courseIds)) {
                builder.or(Expressions.in("studentId", studentIds), Expressions.in("courseId", courseIds));
            } else {
                builder.in("studentId", studentIds);
            }
        } else {
            if (CollectionUtils.isNotEmpty(courseIds)) {
                builder.in("courseId", courseIds);
            }
        }
        builder.gt("status", 0);
        builder.desc("createTime");
        builder.setPage(page);
        return queryList(builder);
    }

    @Override
    public OrgStudentAdvisory getByCallId(Long callId) {
        Preconditions.checkNotNull(callId, "callId is null");
        Preconditions.checkArgument(callId > 0, "call id is illegal:" + callId);
        SingleSqlBuilder<OrgStudentAdvisory> builder = createSqlBuilder();
        builder.eq("callId", callId);
        return uniqueResult(builder);
    }

    @Override
    public void updateStatusByCallId(Long callId, int status) {

    }

    @Override
    public List<Long> getOrgIds(Date startTime, Date endTime) {
        SingleSqlBuilder<OrgStudentAdvisory> builder = createSqlBuilder("orgId");
        if (startTime != null && endTime != null) {
            builder.select("orgId");
            builder.between("createTime", startTime, endTime);
            return queryForList(builder, Long.class);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<Long> query(Date startTime, Date endTime, Long areaId, String key) {
        Map<String, Object> map = Maps.newHashMap();
        StringBuilder builder = new StringBuilder();
        builder.append("select advisory.id from yunying.org_student_advisory advisory ");
        builder.append("inner join yunying.org_info info on advisory.org_id = info.org_id ");
        if (StringUtils.isNotEmpty(key)) {
            builder.append("inner join cdb.org_course course on advisory.course_id = course.id ");
            builder.append("left join cdb.student student on advisory.student_id = student.user_id ");
            builder.append("left join cdb.user user on advisory.student_id = user.id ");
        }
        builder.append("where advisory.create_time between :startTime and :endTime ");
        if (areaId != null) {
            builder.append("and info.area_id =:areaId ");
            map.put("areaId", areaId);
        }
        if (StringUtils.isNotEmpty(key)) {
            builder.append(
                "and (info.shortname like :name or course.name like :name or student.realname like :name or student.nickname like :name or user.mobile like :name)");
            map.put("name", key + "%");
        }
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        log.debug(builder.toString());
        List<Long> result = this.getNamedJdbcTemplate().queryForList(builder.toString(), map, Long.class);
        if (CollectionUtils.isNotEmpty(result)) {
            return result;
        }
        return Lists.newArrayList();
    }

    @Override
    public List<OrgStudentAdvisory> query(Collection<Long> ids, PageDto pageDto, String...querPros) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        SingleSqlBuilder<OrgStudentAdvisory> builder = createSqlBuilder(querPros);
        builder.in("id", ids);
        builder.setPage(pageDto);
        builder.desc("create_time");
        return queryList(builder);
    }

    @Override
    public List<OrgStudentAdvisory> queryUnLogin(Date startTime, Date endTime, Collection<Long> orgIds,
        Integer advisoryType, String contenType, Collection<Integer> statuses, String searchKey,
        Collection<Integer> courseIds, PageDto page) {
        SingleSqlBuilder<OrgStudentAdvisory> builder = createSqlBuilder();
        if (startTime != null && endTime != null) {
            builder.between("createTime", startTime, endTime);
        }
        if (CollectionUtils.isNotEmpty(orgIds)) {
            builder.in("orgId", orgIds);
        }
        if (advisoryType != null) {
            if (advisoryType == 1) {
                builder.eq("advisoryType", advisoryType);
            } else if (advisoryType == 0) {
                builder.eq("advisoryType", advisoryType);
                builder.eq("contentType", contenType);
            } else {
                builder.eq("contentType", contenType);
            }
        }
        if (CollectionUtils.isNotEmpty(statuses)) {
            builder.in("status", statuses);
        }
        if (StringUtils.isNotEmpty(searchKey)) {
            if (CollectionUtils.isNotEmpty(courseIds)) {
                builder.or(Expressions.in("courseId", courseIds),
                    Expressions.like("mobile", searchKey, MatchMode.ANYWHERE));
            } else {
                builder.like("mobile", searchKey, MatchMode.ANYWHERE);
            }
        }
        builder.eq("studentId", 0);
        builder.gt("status", 0);
        builder.desc("createTime");
        builder.setPage(page);
        return queryList(builder);
    }

    @Override
    public List<OrgStudentAdvisory> getAdvisoryListByMinId(Long minId, Date lastDate, int maxSize,
        String...queryProps) {
        Preconditions.checkArgument(maxSize > 0, "maxSize is illegal");
        SingleSqlBuilder<OrgStudentAdvisory> builder = createSqlBuilder(queryProps);
        if (minId == null || minId == 0) {
            if (lastDate == null) {
                throw new IllegalArgumentException("must have minId or lastDate");
            }
            builder.gt("createTime", lastDate);
        } else {
            builder.gt("id", minId);
        }
        builder.asc("createTime");
        builder.setMaxSize(maxSize);
        return queryList(builder);
    }

    @Override
    public int getPeroidTeacherCourseAdvisory(Long courseId, Date startDate, Date endDate) {
        SingleSqlBuilder<OrgStudentAdvisory> builder = createSqlBuilder();
        builder.count("id");
        builder.eq("courseId", courseId);
        builder.eq("contentType", "cdb.teacher_class_course");
        builder.ge("createTime", startDate);
        builder.le("createTime", endDate);
        Integer count = queryForObject(builder, Integer.class);
        if (count == null) {
            return 0;
        }
        return count;
    }

    @Override
    public int getTotalTeacherCourseAdvisory(Long courseId) {
        SingleSqlBuilder<OrgStudentAdvisory> builder = createSqlBuilder();
        builder.count("id");
        builder.eq("courseId", courseId);
        builder.eq("contentType", "cdb.teacher_class_course");
        Integer count = queryForObject(builder, Integer.class);
        if (count == null) {
            return 0;
        }
        return count;
    }

    @Override
    public int getPeroidOrgCourseAdvisory(Long courseId, Date startDate, Date endDate) {
        SingleSqlBuilder<OrgStudentAdvisory> builder = createSqlBuilder();
        builder.count("id");
        builder.eq("courseId", courseId);
        builder.eq("contentType", "cdb.org_course");
        builder.ge("createTime", startDate);
        builder.le("createTime", endDate);
        Integer count = queryForObject(builder, Integer.class);
        if (count == null) {
            return 0;
        }
        return count;
    }

    @Override
    public int getTotalOrgCourseAdvisory(Long courseId) {
        SingleSqlBuilder<OrgStudentAdvisory> builder = createSqlBuilder();
        builder.count("id");
        builder.eq("courseId", courseId);
        builder.eq("contentType", "cdb.org_course");
        Integer count = queryForObject(builder, Integer.class);
        if (count == null) {
            return 0;
        }
        return count;
    }
}
