/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.advisory.dao;

import com.baijia.tianxiao.dal.advisory.constant.AdvisoryType;
import com.baijia.tianxiao.dal.advisory.po.OrgStudentAdvisory;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.Date;
import java.util.List;

/**
 * @title OrgStudentAdvisoryDao
 * @desc TODO
 * @author cxm
 * @date 2015年9月22日
 * @version 1.0
 */
public interface OrgStudentAdvisoryDao extends CommonDao<OrgStudentAdvisory> {

    /**
     * 查询学生咨询列表
     * 
     * @param startTime
     * @param endTime
     * @param orgId
     * @param advisoryType 咨询类型 {@link AdvisoryType}
     * @param statuses 咨询状态 {@link AdvisoryStatus}
     * @param studentIds 根据关键字查询的学生ID列表
     * @param courseIds 根据关键字查询的课程id列表
     * @param page
     * @return
     */
    List<OrgStudentAdvisory> query(Date startTime, Date endTime, Collection<Long> orgIds, Integer advisoryType,
        String contenType, Collection<Integer> statuses, Collection<Long> studentIds, Collection<Integer> courseIds,
        PageDto page);

    /**
     * 查询未登录用户的咨询记录
     * 
     * @param startTime
     * @param endTime
     * @param orgIds
     * @param advisoryType
     * @param contenType
     * @param statuses
     * @param searchKey
     * @param courseIds
     * @param page
     * @return
     */
    List<OrgStudentAdvisory> queryUnLogin(Date startTime, Date endTime, Collection<Long> orgIds, Integer advisoryType,
        String contenType, Collection<Integer> statuses, String searchKey, Collection<Integer> courseIds, PageDto page);

    List<Long> query(Date startTime, Date endTime, Long areaId, String key);

    List<OrgStudentAdvisory> query(Collection<Long> ids, PageDto pageDto, String...querPros);

    /**
     * 根据通话的ID查找记录
     * 
     * @param callId
     * @return
     */
    OrgStudentAdvisory getByCallId(Long callId);

    /**
     * 获取时间段内被咨询的机构
     * 
     * @param startTime
     * @param endTime
     * @return
     */
    List<Long> getOrgIds(Date startTime, Date endTime);

    /**
     * 根据callid更新记录的电话状态
     * 
     * @param callId
     * @param status
     */
    void updateStatusByCallId(Long callId, int status);

    /**
     * 同步专用,根据最小的ID(如果ID为0,则根据最近的日期)获取 @param maxSize 条数据
     * 
     * @param minId
     * @param lastDate
     * @param maxSize
     * @param props
     * @return
     */
    List<OrgStudentAdvisory> getAdvisoryListByMinId(Long minId, Date lastDate, int maxSize, String...queryProps);

    int getPeroidTeacherCourseAdvisory(Long courseId, Date startDate, Date endDate);
    
    int getTotalTeacherCourseAdvisory(Long courseId);
    
    int getPeroidOrgCourseAdvisory(Long courseId, Date startDate, Date endDate);
    
    int getTotalOrgCourseAdvisory(Long courseId);
    
    
    
}
