
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.activity.po.SmsGroupSend;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import lombok.Data;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Aug 29, 2016
 * @Desc this guy is too lazy, nothing left.
 */
@Data
@Entity
@Table(name = "tx_sms_account", catalog = "yunying")
public class SmsAccount {

    @Id
    @GeneratedValue
    @Column(name = "id")
    private Long id;
    @Column(name = "org_id")
    private Long orgId;
    @Column(name = "total_count")
    private int totalCount;
    @Column(name = "send_month")
    private Timestamp sendMonth; // 格式是:yyyy-MM-01 00:00:00
    @Column(name = "create_time")
    private Timestamp createTime;
    @Column(name = "update_time")
    private Timestamp updateTime;
    @Column(name = "count_limit")
    private Integer countLimit;

    public static final String DATA_FORMAT = "yyyy-MM";
    public static final String DATE_FORMAT_ALL = "yyyy-MM-dd HH:mm:dd";

    /**
     * @return
     */
    public static Timestamp createDataMonth() {
        Date currentTime = new Date();
        SimpleDateFormat format = new SimpleDateFormat(DATA_FORMAT);
        String monthDate = format.format(currentTime);
        monthDate = monthDate + "-01 00:00:00";
        Date retDate = null;
        try {
            retDate = format.parse(monthDate);
        } catch (ParseException e) {
            retDate = new Date();
        }
        return new Timestamp(retDate.getTime());
    }

    public static SmsAccount newInstance(Long orgId) {
        SmsAccount account = new SmsAccount();
        account.setOrgId(orgId);
        Timestamp time = new Timestamp(new Date().getTime());
        account.setCreateTime(time);
        account.setUpdateTime(time);
        account.setSendMonth(createDataMonth());
        return account;
    }

}
