package com.baijia.tianxiao.dal.activity.po;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

/**
 * @author Rezar
 * @createDate :Jan 9, 2016 5:05:44 PM
 * @desc : 活动的详情
 */
@Entity
@Table(name = "org_blackboard_info", catalog = "yunying")
public class Activity {

    @Id
    @GeneratedValue
    @Column(name = "id")
    private Long id;
    @Column(name = "bb_type")
    private Integer bbType; // 黑板报类型
    @Column(name = "c_type")
    private Integer cType; // 黑板报内容类型
    @Column(name = "r_type")
    private Integer rType; // 接收者类型 ， 学生，老师，老师和学生
    @Column(name = "sync")
    private Integer sync; // 是否同步到结构主页
    @Column(name = "auditstatus")
    private Integer auditstatus; // 审核状态
    @Column(name = "reason")
    private String reason; // 原因
    @Column(name = "title")
    private String title; // 活动主题
    @Column(name = "create_time")
    private String createTime; // 活动创建时间
    @Column(name = "update_time")
    private String updateTime; // 活动更新时间
    @Column(name = "content")
    private String content; // 活动内容
    @Column(name = "storage_id")
    private Long storageId; // 活动封面图片，可能暂时不用
    @Column(name = "org_id")
    private Integer orgId; // 机构id
    @Column(name = "stick")
    private Integer stick; // 是否置顶
    @Column(name = "switcher")
    private Integer switcher;// 活动配置开关 0:关闭 1:开启 默认关闭
    @Column(name = "qr_url")
    private String qrUrl; // 活动二维码链接
    @Column(name = "support_num")
    private Integer supportNum; // 访问次数
    @Column(name = "isdel")
    private Integer isdel; // 该活动是否删除
    @Column(name = "course_number")
    private Long courseNumber;// 班课number ， 暂时不用

    public Integer getIsdel() {
        return isdel;
    }

    public void setIsdel(Integer isdel) {
        this.isdel = isdel;
    }

    public Long getCourseNumber() {
        return courseNumber;
    }

    public void setCourseNumber(Long courseNumber) {
        this.courseNumber = courseNumber;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getBbType() {
        return bbType;
    }

    public void setBbType(Integer bbType) {
        this.bbType = bbType;
    }

    public Integer getcType() {
        return cType;
    }

    public void setcType(Integer cType) {
        this.cType = cType;
    }

    public Integer getrType() {
        return rType;
    }

    public void setrType(Integer rType) {
        this.rType = rType;
    }

    public Integer getSync() {
        return sync;
    }

    public void setSync(Integer sync) {
        this.sync = sync;
    }

    public Integer getAuditstatus() {
        return auditstatus;
    }

    public void setAuditstatus(Integer auditstatus) {
        this.auditstatus = auditstatus;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Long getStorageId() {
        return storageId;
    }

    public void setStorageId(Long storageId) {
        this.storageId = storageId;
    }

    public Integer getOrgId() {
        return orgId;
    }

    public void setOrgId(Integer orgId) {
        this.orgId = orgId;
    }

    public Integer getStick() {
        return stick;
    }

    public void setStick(Integer stick) {
        this.stick = stick;
    }

    public Integer getSwitcher() {
        return switcher;
    }

    public void setSwitcher(Integer switcher) {
        this.switcher = switcher;
    }

    public String getQrUrl() {
        return qrUrl;
    }

    public void setQrUrl(String qrUrl) {
        this.qrUrl = qrUrl;
    }

    public Integer getSupportNum() {
        return supportNum;
    }

    public void setSupportNum(Integer supportNum) {
        this.supportNum = supportNum;
    }

    @Override
    public String toString() {
        return "Activity [id=" + id + ", bbType=" + bbType + ", cType=" + cType + ", rType=" + rType + ", sync=" + sync
            + ", auditstatus=" + auditstatus + ", reason=" + reason + ", title=" + title + ", createTime=" + createTime
            + ", updateTime=" + updateTime + ", content=" + content + ", storageId=" + storageId + ", orgId=" + orgId
            + ", stick=" + stick + ", switcher=" + switcher + ", qrUrl=" + qrUrl + ", supportNum=" + supportNum
            + ", isdel=" + isdel + ", courseNumber=" + courseNumber + "]";
    }

}
