package com.baijia.tianxiao.dal.activity.dao.vote;

import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.po.vote.VoteInfo;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by liuxp on 16/2/20.
 */
public interface VoteInfoDao extends CommonDao<VoteInfo>{
    public Long insertVoteActivity(VoteInfo voteInfo);

    public void updateVoteActivity(VoteInfo voteInfo);

    public VoteInfo selectVoteInfo(Long activityId, Long orgId);

    public List<VoteInfo> selectVoteInfoList(Integer status, Long orgId, PageInfo pageInfo);

    /**
     * 获得所有参加投票活动及机构id
     */
    public List<Long> getExistOrgIds(List<Long> TianxiaoOrgIds);

    /**
     * 获取每个机构参加的投票活动的activityId
     */
    public Map<Long, List<Long>> getVoteActivityIdsByOrgIds(List<Long> orgIds, Date startTime, Date endTime);

    /**
     * 获取当前正在进行的投票活动
     * 
     * @param orgId
     * @return
     */
    public List<VoteInfo> selectCurrentVoteList(long orgId);

    /**
     * 根据活动状态去查找一个投票活动
     * 
     * @param activityId
     * @param orgId
     * @param delStatus
     * @return
     */
    VoteInfo selectVoteInfo(Long activityId, Long orgId, Integer delStatus);
    
}
