package com.baijia.tianxiao.dal.activity.dao.referral.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.dal.activity.dao.referral.GiftInfoDao;
import com.baijia.tianxiao.dal.activity.po.referral.GiftInfo;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;

/**
 * @author Rezar
 * @createDate :Mar 3, 2016 5:40:46 PM
 * @desc :
 */
@Repository
public class GiftInfoDaoImpl extends JdbcTemplateDaoSupport<GiftInfo> implements GiftInfoDao {

    public GiftInfoDaoImpl() {
        super(GiftInfo.class);
    }

    @Override
    public Long insertGiftInfo(GiftInfo gi) {
        this.save(gi);
        return gi.getId();
    }

    @Override
    public GiftInfo selectGiftById(long giftId) {
        return getById(giftId);
    }

    @Override
    public void deleteGifts(Long activityId, List<Long> gifts) {
        Map<String, Object> paramMap = new HashMap<>();
        StringBuilder sql = new StringBuilder(
            "update yunying.tx_activity_referral_gift set status = 0 where activity_id = :activityId  ");
        if (GenericsUtils.notNullAndEmpty(gifts)) {
            sql.append(" and id not in(:gifts)");
            paramMap.put("gifts", gifts);
        }
        paramMap.put("activityId", activityId);
        this.getNamedJdbcTemplate().update(sql.toString(), paramMap);
    }

    @Override
    public List<GiftInfo> selectGifts(Long activityId) {
        SingleSqlBuilder<GiftInfo> builder = createSqlBuilder();
        builder.eq("activity_id", activityId);
        builder.eq("status", 1);
        List<GiftInfo> giftInfos = queryList(builder);
        return GenericsUtils.isNullOrEmpty(giftInfos) ? Collections.<GiftInfo> emptyList() : giftInfos;
    }

    @Override
    public void updateGifts(List<GiftInfo> gifts) {
        if (GenericsUtils.isNullOrEmpty(gifts)) {
            return;
        }
        for (GiftInfo giftInfo : gifts) {
            this.saveOrUpdate(giftInfo);
        }
    }

    @Override
    public Map<Long, GiftInfo> selectGiftByIds(List<Long> giftIds) {
        SingleSqlBuilder<GiftInfo> bulder = createSqlBuilder();
        bulder.in("id", giftIds);
        List<GiftInfo> queryList = queryList(bulder);
        return CollectionUtils.extractMap(queryList, new CollectionUtils.Extracter<Long, GiftInfo>() {
            @Override
            public Long extract(GiftInfo arg0) {
                return arg0.getId();
            }
        });
    }

}
