package com.baijia.tianxiao.dal.activity.dao.referral;

import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.po.referral.ReferralRecord;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by liuxp on 16/3/4.
 * <p>
 * 推荐记录数据库操作
 */
public interface ReferralRecordDao {
    public List<ReferralRecord> selectRecordsByTime(Long activityId, Date startTime, Date endTime);

    public ReferralRecord selectRecordById(long id);

    public void updateReferralRecord(ReferralRecord record);

    public void addReferralRecord(ReferralRecord record);

    /**
     * 根据被推荐人的手机号查询，同一手机号不能重复推荐
     *
     * @param phone
     * @return
     */
    public ReferralRecord selectByReferralPhone(String phone);

    /**
     * 查询指定时间内经纪人推荐人数
     *
     * @param activityId
     * @param phone
     * @param startTime
     * @param endTime
     * @return
     */
    public int selectCountByBrokerAndTime(Long activityId, String phone, Date startTime, Date endTime);

    /**
     * 分页查询推荐记录
     *
     * @param activityId
     * @param pageInfo
     * @return
     */
    public List<ReferralRecord> selectRecordsByPage(long activityId, PageInfo pageInfo);

    /**
     * 分页查询经纪人列表
     * 
     * @param activityId
     * @param page
     * @return
     */
    List<ReferralRecord> selectBrokersByActivityId(long activityId, PageInfo pageInfo);

    /**
     * 
     * @param activityId
     * @return
     */
    public Map<Long, Integer> listReferrals(List<Long> activityId);

    /**
     * 获取转介绍人数
     * startTime和endDate不为null时，获取某阶段人数
     */
    public Integer getReferralTotal(List<Long> activityIds, Date startTime, Date endTime);

    /**
     * 获取某阶段经纪人数
     * startTime和endDate不为null时，获取某阶段人数
     */
    public Integer getBrokerTotal(List<Long> activityIds, Date startTime, Date endTime);

    /**
     * 导出活动的所有的经纪人
     * 
     * @param activityId
     * @return
     */
    Map<Long, Integer> listBrokerCount(List<Long> activityId);

    /**
     * 导出活动待付报酬的总额
     * 
     * @param activityId
     * @return
     */
    Map<Long, Integer> listToPayCount(List<Long> activityId);

    /**
     * 分页查询经济人记录
     *
     * @param activityId
     * @param status
     * @return
     */
    public List<ReferralRecord> selectBrokersByTime(long activityId, String brokerPhone, int status, Date startTime, Date endTime);

    /**
     * 根据经纪人的手机号码获取到某个月的范围内该经纪人的所有推荐用户的详细记录，加上结算状态进行帅选
     * 
     * @param activityId
     * @param brokerPhone
     * @param status
     * @param lastId
     * @param first
     * @param second
     * @return
     */
    List<ReferralRecord> selectReferralRecordDetail(long activityId, String brokerPhone, Integer status, Date startTime,
        Date endTime, PageInfo pageInfo);
}
