package com.baijia.tianxiao.dal.activity.dao.impl;

import com.baijia.tianxiao.dal.activity.dao.TemplateDao;
import com.baijia.tianxiao.dal.activity.dao.UploadRecordDao;
import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.po.Template;
import com.baijia.tianxiao.dal.activity.po.UploadRecord;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by liuxp on 16/1/8.
 */
@Repository
public class UploadRecordDaoImpl extends JdbcTemplateDaoSupport<UploadRecord> implements UploadRecordDao {

    private static final Logger logger = LoggerFactory.getLogger(UploadRecordDaoImpl.class);

    public UploadRecordDaoImpl() {
        super(UploadRecord.class);
    }

    @Override
    public void insertUploadRecord(UploadRecord record) {
        save(record);
    }

    @Override
    public UploadRecord selectUploadRecordByUid(String uid) {
        SingleSqlBuilder<UploadRecord> builder = createSqlBuilder();
        builder.eq("uid", uid);
        List<UploadRecord> list = queryList(builder);

        if(list!=null && list.size()>0){
            return list.get(0);
        }else {
            return null;
        }
    }
}
