package com.baijia.tianxiao.dal.activity.dao.impl;


import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.dal.activity.dao.TemplateTypeDao;
import com.baijia.tianxiao.dal.activity.po.TemplateType;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

/**
 * Created by liuxp on 16/1/8.
 */
@Repository
public class TemplateTypeDaoImpl extends JdbcTemplateDaoSupport<TemplateType> implements TemplateTypeDao {

    private static final Logger logger = LoggerFactory.getLogger(TemplateTypeDaoImpl.class);

    public TemplateTypeDaoImpl() {
        super(TemplateType.class);
    }

    @Override
    public List<TemplateType> selectTemplateTypeListByCategory(int category) {
        SingleSqlBuilder<TemplateType> builder = createSqlBuilder();
        builder.eq("category",category);
        return queryList(builder);
    }

    @Override
    public Map<Integer, TemplateType> selectTypeByIds(Collection<Integer> typeIds) {
        if(typeIds==null || typeIds.isEmpty()){
            return Collections.emptyMap();
        }

        SingleSqlBuilder<TemplateType> builder = createSqlBuilder();
        builder.in("typeId",typeIds);

        List<TemplateType> types = queryList(builder);

        return CollectionUtils.extractMap(types, new CollectionUtils.Extracter<Integer, TemplateType>() {
            @Override
            public Integer extract(TemplateType templateType) {
                return templateType.getTypeId();
            }
        });
    }
}
