package com.baijia.tianxiao.dal.activity.dao.impl;

import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.activity.dao.ActivityWechatReplaceDao;
import com.baijia.tianxiao.dal.activity.po.ActivityWechatReplace;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

/**
 * @author Rezar
 * @createDate :Jul 8, 2016 1:56:25 AM
 * @desc :
 */
@Repository
public class ActivityWechatReplaceDaoImpl extends JdbcTemplateDaoSupport<ActivityWechatReplace>
    implements ActivityWechatReplaceDao {

    @Override
    public ActivityWechatReplace findByOriginOrgId(Integer originOrgId) {
        SingleSqlBuilder<ActivityWechatReplace> createSqlBuilder = this.createSqlBuilder();
        createSqlBuilder.eq("originOrgId", originOrgId);
        return uniqueResult(createSqlBuilder);
    }

    @Override
    public ActivityWechatReplace findByOReplaceOrgId(Integer replaceOrgId) {
        SingleSqlBuilder<ActivityWechatReplace> createSqlBuilder = this.createSqlBuilder();
        createSqlBuilder.eq("replaceOrgId", replaceOrgId);
        return uniqueResult(createSqlBuilder);
    }

}
