package com.baijia.tianxiao.dal.activity.dao.impl;

import com.baijia.tianxiao.dal.activity.dao.ActivityAccessLogDao;
import com.baijia.tianxiao.dal.activity.po.ActivityAccessLog;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by liuxp on 16/1/13.
 */
@Repository
@Slf4j
public class ActivityAccessLogDaoImpl extends JdbcTemplateDaoSupport<ActivityAccessLog>
    implements ActivityAccessLogDao {
    private static final Logger logger = LoggerFactory.getLogger(ActivityAccessLogDaoImpl.class);

    public ActivityAccessLogDaoImpl() {
        super(ActivityAccessLog.class);
    }

    @Override
    public List<ActivityAccessLog> selectActivityAccessLogByDate(List<String> dateList, Long activityId, int category) {
        if (dateList == null || dateList.isEmpty()) {
            return Collections.emptyList();
        }
        SingleSqlBuilder<ActivityAccessLog> sb = this.createSqlBuilder();
        sb.in("accessDate", dateList);
        sb.eq("activityId", activityId);
        sb.eq("category", category);
        return queryList(sb);
    }

    @Override
    public Map<Long, Integer> selectTotalByActivityId(List<Long> activityIds, int category) {
        String sql =
            "select activity_id,sum(access_count) as count from yunying.tx_activity_access_log where activity_id in (:activityIds) and category=:category group by activity_id";
        Map<String, Object> param = new HashMap<>();
        param.put("activityIds", activityIds);
        param.put("category", category);
        return getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<Long, Integer>>() {

            @Override
            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                Map<Long, Integer> map = new HashMap<Long, Integer>();
                while (rs.next()) {
                    map.put(rs.getLong("activity_id"), rs.getInt("count"));
                }
                return map;
            }
        });
    }

    @Override
    public void insertActivityAccessLog(ActivityAccessLog activityAccessLog) {
        log.info("[ActivityAccessLog] activityAccessLog param:{}", activityAccessLog);
        save(activityAccessLog);
        log.info("[ActivityAccessLog] activityAccessLog param:{}", activityAccessLog);
    }

    @Override
    public void updateActivityAccessLog(Long activityId, String accessDate) {
        String sql =
            "update yunying.tx_activity_access_log set access_count = access_count+1 where activity_id=:activityId and access_date=:accessDate";
        Map<String, Object> param = new HashMap<>();
        param.put("activityId", activityId);
        param.put("accessDate", accessDate);
        getNamedJdbcTemplate().update(sql, param);
    }

    @Override
    public Integer getActivityAccessLogTotal(List<Long> activityIds, Integer category) {
        SingleSqlBuilder<ActivityAccessLog> sql = createSqlBuilder();
        sql.sum("accessCount");
        sql.eq("category", category);
        sql.in("activityId", activityIds);
        return queryForObject(sql, Integer.class);
    }

    @Override
    public Integer getActivityAccessLogTotalByDay(List<Long> activityIds, Integer category, String startDate, String curDate) {
        SingleSqlBuilder<ActivityAccessLog> sql = createSqlBuilder();
        sql.sum("accessCount");
        sql.eq("category", category);
        sql.in("activityId", activityIds);
        sql.between("accessDate", startDate, curDate);
//        sql.eq("accessDate", curDate);
        return queryForObject(sql, Integer.class);
    }

    @Override
    public Map<String, Integer> getActivityAccessLogTotalMap(List<Long> activityIds, Integer category, Date startTime, Date endTime) {
        String sql =
            "select sum(access_count) as count, DATE_FORMAT(access_date,'%y-%m-%d') accessDate from yunying.tx_activity_access_log where "
            + "activity_id in (:activityIds) and category=:category ";
        Map<String, Object> param = new HashMap<>();
        param.put("activityIds", activityIds);
        param.put("category", category);
        
        if (startTime != null && endTime != null) {
            sql += " and access_date between :startTime and :endTime ";
            param.put("endTime", endTime);
            param.put("startTime", startTime);
        }
        sql += "group by MONTH(access_date), DAY(access_date)";
        return getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<String, Integer>>() {

            @Override
            public Map<String, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                Map<String, Integer> map = new HashMap<String, Integer>();
                while (rs.next()) {
                    String accessDate = rs.getString("accessDate");
                    Integer count = rs.getInt("count");
//                    log.info("category======="+ "=========accessDate=======" + accessDate + "=======count========  " + count );
                    map.put(accessDate, count);
                }
                return map;
            }
        });
    }

}
