package com.baijia.tianxiao.dal.activity.dao.draw;

import com.baijia.tianxiao.dal.activity.po.DairyCountStatistics;
import com.baijia.tianxiao.dal.activity.po.draw.ActivityUser;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by liuxp on 16/1/26.
 */
public interface ActivityUserDao {
    public Long insertActivityUser(ActivityUser activityUser);

    public List<DairyCountStatistics> selectDairyCountStatistics(long activityId, int category);

    public ActivityUser selectActivityUser(String wechatOpenId, String date, long activityId, int category);

    public Map<Long, Integer> selectTotalByActivityId(List<Long> activityIds);

    public void updateActivityUserDoneCount(ActivityUser user);

    // 统计某种类型的活动 的参与数量
    public Map<Long, Integer> selectTotalByActivityIdAndCategory(List<Long> activityIds, Integer category);

    // 统计投票活动 所有投票项目的得票数
    public Map<Long, Map<Long, Integer>> statisticalVotes(List<Long> activityIds, Integer category);

    List<ActivityUser> selectActivityUsers(String wechateOpenId, String date, Long activityId, Integer category);

    List<DairyCountStatistics> selectDairyCountStatisticsWithSingle(long activityId, int category);

    /**
     * 统计机构活活动总参与人数
     */
    public Integer getUserTotal(List<Long> activityIds, Integer category, Date startDate, Date endDate);
    
    /**
     * 按日期统计活动总参与人数
     */
    public Map<String, Integer> getUserTotalMap(List<Long> activityIds, Integer category, Date startTime, Date endTime);

    public List<ActivityUser> selectAllUsers(long activityId,int category);

    /**
     * @param wechatOpenId
     * @param activityId
     * @param category
     * @return
     */
    String searchFillUserInfo(String wechatOpenId, long activityId, int category);
}
