
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.activity.dao.SmsgroupSend.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.activity.dao.SmsgroupSend.SmsGroupSendRecordDao;
import com.baijia.tianxiao.dal.activity.po.SmsGroupSend.SmsGroupSendRecord;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Aug 17, 2016
 * @desc
 */
@Repository
@Slf4j
public class SmsGroupSendRecordDaoImpl extends JdbcTemplateDaoSupport<SmsGroupSendRecord>
    implements SmsGroupSendRecordDao {

    /**
     * 查找某个机构所有的短信群发记录 TODO ,排序
     * 
     * <br/>
     * 
     * Just from query IDS
     */
    @Override
    public List<SmsGroupSendRecord> listAllSmsGroupRecords(Long orgId, Long lastRecordId, PageDto pageDto,
        String...props) {

        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", lastRecordId);
        paramMap.put("orgId", orgId);
        paramMap.put("sendStatus", 0);
        paramMap.put("firstIndex", (pageDto.getPageNum() - 1) * pageDto.getPageSize());
        paramMap.put("pageSize", pageDto.getPageSize());

        String sql = "select id from yunying.tx_sms_group_send_record o1,"
            + " (select send_time from yunying.tx_sms_group_send_record where id = :id  and send_status = :sendStatus ) o2 "
            + " where  o1.org_id =:orgId  and send_status = :sendStatus and (o1.send_time < o2.send_time or (o1.send_time = o2.send_time and o1.id < :id)) "
            + " order by o1.send_time desc,o1.id desc limit :firstIndex,:pageSize";

        if (lastRecordId == null || lastRecordId == 0) {
            sql =
                "select id from yunying.tx_sms_group_send_record where org_id = :orgId and send_status = 0  order by send_time desc , id desc limit :firstIndex,:pageSize ";
            paramMap.remove("id");
        }

        log.info("query sql is : {} and param Map is : {} ", sql, paramMap);

        return this.getNamedJdbcTemplate().query(sql, paramMap, new ResultSetExtractor<List<SmsGroupSendRecord>>() {

            @Override
            public List<SmsGroupSendRecord> extractData(ResultSet rs) throws SQLException, DataAccessException {
                List<SmsGroupSendRecord> smsGroupSendRecords = new ArrayList<>();
                while (rs.next()) {
                    log.info("resultSet is : {} ", ToStringBuilder.reflectionToString(rs));
                    smsGroupSendRecords.add(toSmsGroupSendRecord(rs));
                }
                log.info("smsGroupSendRecords are : {}", smsGroupSendRecords);
                return smsGroupSendRecords;
            }

            private SmsGroupSendRecord toSmsGroupSendRecord(ResultSet rs) throws SQLException {
                SmsGroupSendRecord record = new SmsGroupSendRecord();
                record.setId(rs.getLong("id"));
                return record;
            }
        });
    }

    /**
     * 根据记录以及机构ID来查找某条群发记录
     */
    @Override
    public SmsGroupSendRecord searchRecordWithOrgId(Long recordId, Long orgId) {
        SingleSqlBuilder<SmsGroupSendRecord> createSqlBuilder = this.createSqlBuilder();
        createSqlBuilder.eq("id", recordId);
        createSqlBuilder.eq("orgId", orgId);
        return this.uniqueResult(createSqlBuilder);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * com.baijia.tianxiao.dal.activity.dao.SmsgroupSend.SmsGroupSendRecordDao#searchRecordsWithOrgId(java.lang.Long,
     * java.util.HashSet)
     */
    @Override
    public List<SmsGroupSendRecord> searchRecordsWithOrgId(Long orgId, Collection<Long> newHashSet) {
        SingleSqlBuilder<SmsGroupSendRecord> createSqlBuilder = this.createSqlBuilder();
        createSqlBuilder.eq("orgId", orgId);
        createSqlBuilder.in("id", newHashSet);
        return this.queryList(createSqlBuilder);
    }

}
