package com.baijia.tianxiao.dal.activity.dao;

import com.baijia.tianxiao.dal.activity.po.ActivityAccessLog;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by liuxp on 16/1/13.
 */
public interface ActivityAccessLogDao extends CommonDao<ActivityAccessLog>{
    public List<ActivityAccessLog> selectActivityAccessLogByDate(List<String> dateList,Long activityId,int category);

    public Map<Long, Integer> selectTotalByActivityId(List<Long> activityIds,int category);

    public void insertActivityAccessLog(ActivityAccessLog log);

    public void updateActivityAccessLog(Long activityId,String accessDate);

    /**
     * 获取某机构所有活动总访问量
     * @param activityIds
     * @param category
     * @return
     */
    public Integer getActivityAccessLogTotal(List<Long> activityIds, Integer category);

    public Integer getActivityAccessLogTotalByDay(List<Long> activityIds, Integer category, String startDate, String curDate);
    
    public Map<String, Integer> getActivityAccessLogTotalMap(List<Long> activityIds, Integer category, Date startTime, Date endTime);
}
