package com.baijia.tianxiao.dal.activity.constants;

import com.baijia.tianxiao.dal.activity.po.Template;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * Created by liuxp on 16/3/25.
 */
@Slf4j
public class TemplateConstant {
    private final static Map<Integer,Template> map = new HashMap<>();

    public static String getTemplateUrl(Integer templateId){
        Template template = map.get(templateId);
        if(template!=null){
            return template.getUrl();
        }else {
            Set<Integer> keySet = map.keySet();
            for(Integer key:keySet){
                log.info("[TemplateKey] Key="+key);
                Template temp = map.get(key);
                if(temp.getTypeId()==templateId.intValue()){
                    return temp.getUrl();
                }
            }
        }
        log.error("[TemplateException] TemplateId is error.TemplateId="+templateId);
        return "";
    }

    public static Map<Integer,Template> getMap(){
        return map;
    }
}
