package com.baijia.tianxiao.constant;

/**
 * Created by liuxp on 16/8/9.
 */
public enum Visibility {
    HIDDEN(0,"不可见"),
    VISIBLE(1,"全部可见"),
    FREE_HIDDEN(2,"免费版不可见"),
    ;

    private int type;
    private String desc;

    private Visibility(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    private static Visibility getType(int type){
        for (Visibility v:Visibility.values()){
            if (v.type==type){
                return v;
            }
        }
        return null;
    }

    public static boolean isVisible(int type,boolean isFree){
        Visibility v = getType(type);
        switch (v){
            case VISIBLE:
                return true;
            case FREE_HIDDEN:
                return !isFree;
            default:
                return false;
        }
    }
}
