package com.baijia.tianxiao.constant;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * Created by wengshengli on 2016/11/30.
 */
public enum StudentFiannceOpType {

    QUIT_CLASS(1, "退班", 1),

    REFUND_CASH(2, "账户退款", 2),

    SIGNUP_PAY(3, "支付", 2),

    PAY_CANCEL(4, "取消支付", 1),

    PAY_SUCCESS(5, "支付成功", 2),

    RECHARGE(6, "充值", 1),

    TRANSFER_REFUND(7, "退差价", 1);

    private Integer code;
    private String name;
    private Integer opTo;

    private static Map<Integer, StudentFiannceOpType> map = Maps.newHashMap();

    static {
        for (StudentFiannceOpType opType : StudentFiannceOpType.values()) {
            map.put(opType.code, opType);
        }
    }

    StudentFiannceOpType(int code, String name, Integer opTo) {
        this.code = code;
        this.name = name;
        this.opTo = opTo;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getOpTo() {
        return opTo;
    }

    public void setOpTo(Integer opTo) {
        this.opTo = opTo;
    }

    public static StudentFiannceOpType getByCode(Integer code) {
        return map.get(code);
    }

    @Override
    public String toString() {
        return "[" + this.getCode() + " " + this.name + " " + this.opTo + "]";
    }
}
