
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.constant;


/**
 * @author : zhenyujian
 * @title : BooleanStatus
 * @description :
 * @date : 2016年5月22日 下午9:49:20
 */
public enum Flag {

    NULL(-1), FALSE(0), TRUE(1);

    private int val;

    private Flag(int val) {
        this.val = val;
    }

    public int getInt() {
        return this.val;
    }

    public long getLong() {
        return (long) this.val;
    }
    
    public Boolean getBoolean(){
    	switch (this){
    		case TRUE:
    			return true;
    		case FALSE:
    			return false;
    	}
    	return null;
    }

    public static boolean getBoolean(Integer value) {
        if (value != null && value.intValue() == TRUE.val) {
            return true;
        }
        return false;
    }
    
    public static boolean isBooleanInt(Integer num){
    	if(num!=null){
    		if(num.equals(TRUE.getInt()) || num.equals(FALSE.getInt())){
    			return true;
    		}
    	}
    	return false;
    }

}
