/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.sqlBuilder;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;
import com.baijia.tianxiao.sqlbuilder.util.VariableChangeUtils;
import com.baijia.tianxiao.util.CollectorUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class BatchInsertSqlCreator<PO> {
    private static final Logger log = LoggerFactory.getLogger(BatchInsertSqlCreator.class);
    private static final String split = "'";
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
    private Class<PO> clazz;
    private String catalog;
    private String tableName;
    private List<? extends PO> poList;
    private List<String> insertProps;
    private List<String> convertProps;

    public BatchInsertSqlCreator(List<? extends PO> poList, String ... props) {
        try {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(poList), (Object)"the poList canot be null or empty!");
            this.poList = poList;
            this.clazz = poList.get(0).getClass();
            Preconditions.checkArgument((boolean)this.clazz.isAnnotationPresent(Table.class), (Object)"this is not a sql-builder po list!(no @Table annotation)");
            this.catalog = this.clazz.getAnnotation(Table.class).catalog();
            this.tableName = this.clazz.getAnnotation(Table.class).name();
            this.tableName = StringUtils.isNotEmpty((CharSequence)this.tableName) ? this.tableName : this.clazz.getAnnotation(Entity.class).name();
            Preconditions.checkArgument((StringUtils.isNotEmpty((CharSequence)this.catalog) && StringUtils.isNotEmpty((CharSequence)this.tableName) ? 1 : 0) != 0, (Object)"no catalog or tableName");
            this.insertProps = this.getAllPOProps(props);
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.insertProps), (Object)"read props failed! no field is annotationed with @Column or @Id");
            this.convertProps = this.convertToSqlProps(this.insertProps);
        }
        catch (Exception e) {
            log.error("BatchInsertSqlCreator initialize failed, exception is:{}", (Throwable)e);
            throw e;
        }
    }

    private List<String> convertToSqlProps(List<String> insertProps) {
        ArrayList convertProps = Lists.newArrayList();
        for (String prop : insertProps) {
            Field field = this.clazz.getDeclaredField(prop);
            if (field.isAnnotationPresent(Id.class)) {
                convertProps.add(prop);
                continue;
            }
            if (!field.isAnnotationPresent(Column.class)) continue;
            String temp = field.getAnnotation(Column.class).name();
            convertProps.add(StringUtils.isNotEmpty((CharSequence)temp) ? temp : VariableChangeUtils.camelToUnderline((String)prop));
        }
        return convertProps;
    }

    private List<String> getAllPOProps(String ... props) {
        ArrayList allProps = Lists.newArrayList();
        if (props.length > 0) {
            for (String prop : props) {
                Field field = this.clazz.getDeclaredField(prop);
                if (!field.isAnnotationPresent(Column.class) && !field.isAnnotationPresent(Id.class)) continue;
                allProps.add(field.getName());
            }
        } else {
            Field[] fields;
            for (Field field : fields = this.clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Column.class) && !field.isAnnotationPresent(Id.class)) continue;
                allProps.add(field.getName());
            }
        }
        return allProps;
    }

    public String toSql() {
        String insertSql = this.createInsertHead();
        String valueSql = this.createValueBody();
        return insertSql + valueSql;
    }

    private String createValueBody() {
        Map fieldMap = CollectorUtil.collectMap((Collection)Lists.newArrayList((Object[])this.clazz.getDeclaredFields()), (Function)new Function<Field, String>(){

            public String apply(Field input) {
                input.setAccessible(true);
                return input.getName();
            }
        });
        ArrayList valueList = Lists.newArrayList();
        for (PO po : this.poList) {
            ArrayList values = Lists.newArrayList();
            Field field = null;
            Object value = null;
            for (String prop : this.insertProps) {
                field = (Field)fieldMap.get(prop);
                value = field.get(po);
                if (value instanceof Date) {
                    values.add(null == value ? null : split + format.format(value) + split);
                    continue;
                }
                values.add(null == value ? null : split + value.toString().replace("\\", "\\\\").replace(split, "\\'") + split);
            }
            valueList.add(values);
        }
        String valueSql = ((Object)valueList).toString().replace("[", "(").replace("]", ")");
        valueSql = valueSql.substring(1, valueSql.length() - 1);
        return valueSql;
    }

    private String createInsertHead() {
        StringBuilder insertSql = new StringBuilder("INSERT INTO ");
        insertSql.append(this.catalog);
        insertSql.append(".");
        insertSql.append(this.tableName);
        insertSql.append(" ");
        insertSql.append(this.convertProps.toString().replace("[", "(").replace("]", ")"));
        insertSql.append(" VALUES ");
        return insertSql.toString();
    }
}

