/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.wechat.dao.impl;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.wechat.dao.UnifiedWechatAccountDao;
import com.baijia.tianxiao.dal.wechat.po.UnifiedWechatAccount;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class UnifiedWechatAccountDaoImpl
extends JdbcTemplateDaoSupport<UnifiedWechatAccount>
implements UnifiedWechatAccountDao {
    private static final Logger log = LoggerFactory.getLogger(UnifiedWechatAccountDaoImpl.class);

    @Override
    public List<UnifiedWechatAccount> listAllCampusWithAnyOneOrgInfo(Long orgId, boolean isOrgId) {
        SingleSqlBuilder singleBuilder = this.createSqlBuilder(new String[0]);
        String sqlSelect = singleBuilder.toSql();
        UnifiedWechatAccount findUnifiedWechatRecordWithOrgId = this.findUnifiedWechatRecord(orgId, isOrgId, DeleteStatus.NORMAL.getValue());
        if (findUnifiedWechatRecordWithOrgId == null) {
            return GenericsUtils.emptyList();
        }
        log.info("findUnifiedWechatRecordWithOrgId is :{} ", (Object)findUnifiedWechatRecordWithOrgId);
        Long masterOrgId = orgId;
        if (findUnifiedWechatRecordWithOrgId.getMasterOrgId() != 0) {
            masterOrgId = findUnifiedWechatRecordWithOrgId.getMasterOrgId().longValue();
        }
        HashMap paramMaps = Maps.newHashMap();
        paramMaps.put("masterOrgId", masterOrgId);
        String sql = sqlSelect + " where del_status = 0 and  (master_org_id = :masterOrgId or org_id =:masterOrgId) order by create_time desc";
        log.info("querySql is :{} and paramMap is :{} ", (Object)sql, (Object)paramMaps);
        List query = this.getNamedJdbcTemplate().query(sql, (Map)paramMaps, (RowMapper)new BeanPropertyRowMapper(UnifiedWechatAccount.class));
        query = GenericsUtils.isNullOrEmpty((Object)query) ? GenericsUtils.emptyList() : query;
        return query;
    }

    @Override
    public UnifiedWechatAccount findUnifiedWechatRecord(Long orgId, boolean isOrgId, Integer delStatus) {
        List<UnifiedWechatAccount> findUnifiedWechatRecords = this.findUnifiedWechatRecords(Arrays.asList(orgId), isOrgId, delStatus);
        return GenericsUtils.isNullOrEmpty(findUnifiedWechatRecords) ? null : findUnifiedWechatRecords.get(0);
    }

    @Override
    public List<UnifiedWechatAccount> findUnifiedWechatRecords(Collection<Long> ordIds, boolean isOrgId, Integer delStatus) {
        List queryList;
        SingleSqlBuilder singleBuilder = this.createSqlBuilder(new String[0]);
        singleBuilder.in(isOrgId ? "orgId" : "orgNumber", ordIds);
        if (delStatus != null) {
            singleBuilder.eq("delStatus", (Serializable)delStatus);
        }
        queryList = GenericsUtils.isNullOrEmpty((Object)(queryList = this.queryList(singleBuilder))) ? GenericsUtils.emptyList() : queryList;
        return queryList;
    }

    @Override
    public void deleteByOrgId(Long orgId) {
        log.info("del record with orgId:{} ", (Object)orgId);
        String sql = "update yunying.tx_unified_wechat_account set del_status = 1 , init_status = -1 where  master_org_id = :orgId";
        HashMap paramMaps = Maps.newHashMap();
        paramMaps.put("orgId", orgId);
        this.getNamedJdbcTemplate().update(sql, (Map)paramMaps);
        sql = "update yunying.tx_unified_wechat_account set del_status = 1, init_status = -1  where org_id =:orgId";
        this.getNamedJdbcTemplate().update(sql, (Map)paramMaps);
    }

    @Override
    public void deleteSlaveCampusByOrgId(Long slaveCampusOrgId) {
        log.info("del slaveCampus with orgId:{} ", (Object)slaveCampusOrgId);
        String sql = "update yunying.tx_unified_wechat_account set del_status = 1 where  org_id = :orgId";
        HashMap paramMaps = Maps.newHashMap();
        paramMaps.put("orgId", slaveCampusOrgId);
        this.getNamedJdbcTemplate().update(sql, (Map)paramMaps);
    }

    @Override
    public UnifiedWechatAccount findMasterAccountWithAnyCampusOrgId(Integer orgId, Boolean isInit) {
        UnifiedWechatAccount findUnifiedWechatRecordWithOrgId = this.findUnifiedWechatRecord(orgId.longValue(), true, DeleteStatus.NORMAL.getValue());
        log.info("find UnifiedWechatAccount first :{} ", (Object)findUnifiedWechatRecordWithOrgId);
        if (findUnifiedWechatRecordWithOrgId == null) {
            return null;
        }
        SingleSqlBuilder singleBuilder = this.createSqlBuilder(new String[0]);
        if (isInit != null) {
            Integer initStatus = isInit != false ? 0 : -1;
            singleBuilder.eq("initStatus", (Serializable)initStatus);
        }
        Integer masterOrgId = orgId;
        if (findUnifiedWechatRecordWithOrgId.getMasterOrgId() != 0) {
            masterOrgId = findUnifiedWechatRecordWithOrgId.getMasterOrgId();
        }
        singleBuilder.eq("orgId", (Serializable)masterOrgId);
        UnifiedWechatAccount ret = (UnifiedWechatAccount)this.uniqueResult(singleBuilder);
        log.info("ret : {} ", (Object)ret);
        return ret;
    }

    @Override
    public boolean resetOrgWechatTypeIfNecessary(Integer masterOrgId) {
        if (masterOrgId == null) {
            return false;
        }
        SingleSqlBuilder singleBuilder = this.createSqlBuilder(new String[0]);
        String sqlSelect = singleBuilder.toSql();
        String sql = sqlSelect + " where master_org_id =:masterOrgId and del_status = :status for update ";
        HashMap paramMaps = Maps.newHashMap();
        paramMaps.put("status", DeleteStatus.NORMAL.getValue());
        paramMaps.put("masterOrgId", masterOrgId);
        log.info("sql is :{} ", (Object)sql);
        List queryResult = this.getNamedJdbcTemplate().query(sql, (Map)paramMaps, (RowMapper)new BeanPropertyRowMapper(UnifiedWechatAccount.class));
        log.info("query result is :{} ", (Object)queryResult);
        if (GenericsUtils.isNullOrEmpty((Object)queryResult)) {
            log.info("queryResult is empty , need reset masterOrg :{} ", (Object)masterOrgId);
            this.deleteByOrgId(masterOrgId.longValue());
            return true;
        }
        return false;
    }
}

