/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.wechat.dao.impl;

import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.UnifiedWechatAccountDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.UnifiedWechatAccount;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository(value="tianxiao_dal_yunying_authorizationInfoDao")
public class AuthorizationInfoDaoImpl
extends JdbcTemplateDaoSupport<AuthorizationInfo>
implements AuthorizationInfoDao {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationInfoDaoImpl.class);
    @Autowired
    private UnifiedWechatAccountDao unifiedWechatAccountDao;

    public AuthorizationInfoDaoImpl() {
        super(AuthorizationInfo.class);
    }

    @Override
    public void deleteByOrgId(Integer orgId) {
        HashMap<String, Integer> condition = new HashMap<String, Integer>();
        condition.put("orgId", orgId);
        this.delByCondition(condition);
    }

    @Override
    public void deleteByAuthorizerAppId(String authorizerAppId) {
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("authorizerAppId", authorizerAppId);
        this.delByCondition(condition);
    }

    @Override
    public AuthorizationInfo getByOrgId(Integer orgId) {
        return this.getByOrgId(orgId, true);
    }

    @Override
    public AuthorizationInfo getByOrgId(Integer orgId, boolean withMasterSearch) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        AuthorizationInfo uniqueResult = (AuthorizationInfo)this.uniqueResult(builder);
        if (uniqueResult == null && withMasterSearch) {
            UnifiedWechatAccount orgIdOfMaster = this.unifiedWechatAccountDao.findMasterAccountWithAnyCampusOrgId(orgId, true);
            log.info("UnifiedWechatAccount is :{} ", (Object)orgIdOfMaster);
            if (orgIdOfMaster != null && (uniqueResult = this.getByOrgId(orgIdOfMaster.getOrgId().intValue(), false)) != null) {
                uniqueResult.setOrgId(orgId);
                uniqueResult.setOrgWechatType(1);
                uniqueResult.setMasterOrgId(orgIdOfMaster.getOrgId().intValue());
            }
        }
        return uniqueResult;
    }

    @Override
    public AuthorizationInfo getByAuthorizerAppId(String authorizerAppId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("authorizerAppId", (Serializable)((Object)authorizerAppId));
        return (AuthorizationInfo)this.uniqueResult(builder);
    }

    @Override
    public Map<Long, String> mapAppIdByorgId(List<Long> orgIds) {
        final HashMap<Long, String> map = new HashMap<Long, String>();
        String sql = "SELECT * FROM yunying.org_wechat_authorization_info WHERE org_id IN (:orgIds)";
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, List<Long>> params = new HashMap<String, List<Long>>();
        params.put("orgIds", orgIds);
        template.query(sql, params, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                map.put(rs.getLong("org_id"), rs.getString("authorizer_app_id"));
                return 1;
            }
        });
        for (Long orgId : orgIds) {
            AuthorizationInfo byOrgId;
            String appId = (String)map.get(orgId);
            if (!GenericsUtils.isNullOrEmpty((Object)appId) || (byOrgId = this.getByOrgId(orgId.intValue(), true)) == null) continue;
            map.put(orgId, byOrgId.getAuthorizerAppId());
        }
        return map;
    }
}

