/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.todo.dao.impl;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.todo.dao.TxBacklogParticipantDao;
import com.baijia.tianxiao.dal.todo.po.TxbacklogParticipant;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class TxBacklogParticipantDaoImpl
extends JdbcTemplateDaoSupport<TxbacklogParticipant>
implements TxBacklogParticipantDao {
    public TxBacklogParticipantDaoImpl() {
        super(TxbacklogParticipant.class);
    }

    @Override
    public List<TxbacklogParticipant> listByBackLogId(Long backlogId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("backlogId", (Serializable)backlogId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(Flag.FALSE.getInt()));
        return this.queryList(builder);
    }

    @Override
    public List<TxbacklogParticipant> listByBackLogId(Long backlogId, Boolean delStatus) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("backlogId", (Serializable)backlogId);
        if (delStatus != null) {
            if (delStatus.booleanValue()) {
                builder.eq("delStatus", (Serializable)Integer.valueOf(Flag.TRUE.getInt()));
            } else {
                builder.eq("delStatus", (Serializable)Integer.valueOf(Flag.FALSE.getInt()));
            }
        }
        return this.queryList(builder);
    }

    @Override
    public List<TxbacklogParticipant> listBy(Long orgId, Long cascadeId, List<Long> backlogIds, Boolean finish) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("cascadeId", (Serializable)cascadeId);
        builder.in("backlogId", backlogIds);
        if (finish != null) {
            if (finish.booleanValue()) {
                builder.eq("finish", (Serializable)Integer.valueOf(Flag.TRUE.getInt()));
            } else {
                builder.eq("finish", (Serializable)Integer.valueOf(Flag.FALSE.getInt()));
            }
        }
        builder.eq("delStatus", (Serializable)Integer.valueOf(Flag.FALSE.getInt()));
        return this.queryList(builder);
    }

    @Override
    public List<TxbacklogParticipant> listBy(Long orgId, Long cascadeId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("cascadeId", (Serializable)cascadeId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(Flag.FALSE.getInt()));
        return this.queryList(builder);
    }

    @Override
    public Map<Long, TxbacklogParticipant> keyBacklogIdValueParticipant(Long orgId, Long cascadeId) {
        HashMap<Long, TxbacklogParticipant> map = new HashMap<Long, TxbacklogParticipant>();
        List<TxbacklogParticipant> list = this.listBy(orgId, cascadeId);
        if (CollectionUtils.isNotEmpty(list)) {
            for (TxbacklogParticipant obj : list) {
                map.put(obj.getBacklogId(), obj);
            }
        }
        return map;
    }

    @Override
    public void delByBackLogId(Long backlogId) {
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        String sql = "UPDATE yunying.tx_backlog_participants SET del_status=1 WHERE backlog_id=:backlogId";
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("backlogId", backlogId);
        template.update(sql, params);
    }

    @Override
    public void physicallyDelByIds(List<Long> ids) {
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        String sql = "DELETE FROM yunying.tx_backlog_participants WHERE id IN (:ids)";
        HashMap<String, List<Long>> params = new HashMap<String, List<Long>>();
        params.put("ids", ids);
        template.update(sql, params);
    }

    @Override
    public void delBy(Long orgId, Long cascadeId, Long backlogId) {
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        String sql = "UPDATE yunying.tx_backlog_participants SET del_status=1 WHERE backlog_id=:backlogId AND org_id=:orgId AND cascade_id=:cascadeId";
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("backlogId", backlogId);
        params.put("orgId", orgId);
        params.put("cascadeId", cascadeId);
        template.update(sql, params);
    }

    @Override
    public void delBy(Long orgId, Long cascadeId, List<Long> backlogIds) {
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        String sql = "UPDATE yunying.tx_backlog_participants SET del_status=1 WHERE backlog_id IN (:backlogIds) AND org_id=:orgId AND cascade_id=:cascadeId";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("backlogIds", backlogIds);
        params.put("orgId", orgId);
        params.put("cascadeId", cascadeId);
        template.update(sql, params);
    }

    @Override
    public TxbacklogParticipant getBy(Long orgId, Long cascadeId, Long backlogId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("backlogId", (Serializable)backlogId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("cascadeId", (Serializable)cascadeId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(Flag.FALSE.getInt()));
        return (TxbacklogParticipant)this.uniqueResult(builder);
    }

    @Override
    public void batchChangeFinish(List<Long> ids, Boolean finish) {
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        String sql = "UPDATE yunying.tx_backlog_participants SET finish=:finish WHERE id IN (:ids)";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ids", ids);
        if (finish != null) {
            if (finish.booleanValue()) {
                params.put("finish", Flag.TRUE.getInt());
            } else {
                params.put("finish", Flag.FALSE.getInt());
            }
        }
        template.update(sql, params);
    }
}

