/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.sync.dao.impl;

import com.baijia.tianxiao.dal.sync.dao.TxUserSourceStatisticDayDao;
import com.baijia.tianxiao.dal.sync.po.TxUserSourceStatisticDay;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.io.Serializable;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class TxUserSourceStatisticDayDaoImpl
extends JdbcTemplateDaoSupport<TxUserSourceStatisticDay>
implements TxUserSourceStatisticDayDao {
    private static final Logger log = LoggerFactory.getLogger(TxUserSourceStatisticDayDaoImpl.class);

    @Override
    public TxUserSourceStatisticDay getTxUserSourceStatisticDay(Long orgId, Long consultUserId, Integer sourceType, Date startTime, Date endTime) {
        log.info("txUserSourceStatistic orgId {}, consultUserId {}, sourceType {}", (Object)orgId, (Object)consultUserId);
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("consultUserId", (Serializable)consultUserId);
        builder.eq("sourceType", (Serializable)sourceType);
        builder.ge("visitDate", (Serializable)startTime);
        builder.lt("visitDate", (Serializable)endTime);
        builder.setMaxSize(Integer.valueOf(1));
        return (TxUserSourceStatisticDay)this.uniqueResult(builder);
    }

    @Override
    public int countByOrgSource(Long orgId, int sourceType, Date startTime, Date endTime) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.sum("number");
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("sourceType", (Serializable)Integer.valueOf(sourceType));
        builder.ge("visitDate", (Serializable)startTime);
        builder.lt("visitDate", (Serializable)endTime);
        log.info("count by org source sql= {},params:{orgId={},sourceType={},startTime={},endTime={}}", new Object[]{builder.toSql(), orgId, sourceType, startTime, endTime});
        Integer num = (Integer)this.queryForObject(builder, Integer.class);
        return num == null ? 0 : num;
    }
}

