/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.sync.dao.impl;

import com.baijia.tianxiao.dal.sync.dao.TxConsultUserStatMonthDao;
import com.baijia.tianxiao.dal.sync.po.TxConsultUserStatMonth;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class TxConsultUserStatMonthDaoImpl
extends JdbcTemplateDaoSupport<TxConsultUserStatMonth>
implements TxConsultUserStatMonthDao {
    private static final Logger log = LoggerFactory.getLogger(TxConsultUserStatMonthDaoImpl.class);

    public TxConsultUserStatMonthDaoImpl() {
        super(TxConsultUserStatMonth.class);
    }

    @Override
    public int countByOrgConsultStatus(Long orgId, int status, int monthDiff) {
        HashMap params = Maps.newHashMap();
        params.put("orgId", orgId);
        params.put("monthDiff", monthDiff);
        params.put("status", status);
        StringBuilder sb = new StringBuilder("select count(1) from (select count(1) from yunying.tx_consult_stat_month");
        sb.append(" where org_id = :orgId");
        sb.append(" and  date_format(create_time,'%Y-%m')=date_format(DATE_SUB(curdate(), INTERVAL :monthDiff MONTH),'%Y-%m') and status >=:status group by consult_user_id,user_id) a");
        log.info("countByOrgConsultStatus sql= {},params:{orgId={},monthDiff={},status={}}", new Object[]{sb.toString(), orgId, monthDiff, status});
        return (Integer)this.getNamedJdbcTemplate().queryForObject(sb.toString(), (Map)params, Integer.class);
    }

    @Override
    public int countEnrolls(Long orgId, int status, Date startTime, Date endTime) {
        HashMap params = Maps.newHashMap();
        params.put("orgId", orgId);
        params.put("status", status);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        StringBuilder sb = new StringBuilder("select count(1) from (select consult_user_id,user_id from yunying.tx_consult_stat_month");
        sb.append(" where org_id = :orgId");
        sb.append(" and create_time between :startTime and :endTime and status =:status group by consult_user_id,user_id) c");
        log.info("countByOrgConsultStatus sql= {},params:{orgId={},monthDiff={},status={}}", new Object[]{sb.toString(), orgId, status});
        return (Integer)this.getNamedJdbcTemplate().queryForObject(sb.toString(), (Map)params, Integer.class);
    }

    @Override
    public List<TxConsultUserStatMonth> getPageTxConsultUserStatMonthByStatus(Long orgId, int status, Date startDate, Date endDate, PageDto pageDto) {
        HashMap params = Maps.newHashMap();
        params.put("orgId", orgId);
        params.put("status", status);
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        StringBuilder sb = new StringBuilder("select * from yunying.tx_consult_stat_month ");
        sb.append(" where org_id = :orgId");
        sb.append(" and create_time between :startDate and :endDate and status =:status group by consult_user_id,user_id");
        if (GenericsUtils.notNullAndEmpty((Object)pageDto)) {
            int start = (pageDto.getPageNum() - 1) * pageDto.getPageSize();
            int limit = pageDto.getPageSize();
            sb.append(" limit :start, :limit");
            params.put("start", start);
            params.put("limit", limit);
        }
        log.info("getPageTxConsultUserStatMonthByStatus sql= {},params:{orgId={}, startDate={}, endDate={}status={}}", new Object[]{sb.toString(), orgId, startDate, endDate, status});
        return (List)this.getNamedJdbcTemplate().query(sb.toString(), (Map)params, (ResultSetExtractor)new ResultSetExtractor<List<TxConsultUserStatMonth>>(){

            public List<TxConsultUserStatMonth> extractData(ResultSet rs) throws SQLException, DataAccessException {
                ArrayList<TxConsultUserStatMonth> list = new ArrayList<TxConsultUserStatMonth>();
                while (rs.next()) {
                    TxConsultUserStatMonth txConsultUserStatMonth = TxConsultUserStatMonthDaoImpl.this.getInstance(rs);
                    list.add(txConsultUserStatMonth);
                }
                return list;
            }
        });
    }

    @Override
    public TxConsultUserStatMonth getTxConsultStatByQuery(long orgId, long consultUserId, long userId, Integer sourceType, Date startTime, Date endTime) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)Long.valueOf(orgId));
        if (consultUserId != 0L) {
            builder.eq("consultUserId", (Serializable)Long.valueOf(consultUserId));
        } else {
            builder.eq("userId", (Serializable)Long.valueOf(userId));
        }
        if (GenericsUtils.notNullAndEmpty((Object)sourceType)) {
            builder.eq("sourceType", (Serializable)sourceType);
        }
        builder.ge("createTime", (Serializable)startTime);
        builder.lt("createTime", (Serializable)endTime);
        builder.setMaxSize(Integer.valueOf(1));
        builder.desc("createTime");
        return (TxConsultUserStatMonth)this.uniqueResult(builder);
    }

    @Override
    public int countByTime(long orgId, Date startTime, Date endTime) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)Long.valueOf(orgId));
        builder.sum("number");
        builder.ge("updateTime", (Serializable)startTime);
        builder.lt("updateTime", (Serializable)endTime);
        builder.group("orgId");
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    private TxConsultUserStatMonth getInstance(ResultSet rs) throws SQLException, DataAccessException {
        TxConsultUserStatMonth txConsultUserStatMonth = new TxConsultUserStatMonth();
        txConsultUserStatMonth.setId(rs.getLong("id"));
        txConsultUserStatMonth.setConsultUserId(rs.getLong("consult_user_id"));
        txConsultUserStatMonth.setUserId(rs.getLong("user_id"));
        txConsultUserStatMonth.setOrgId(rs.getLong("org_id"));
        txConsultUserStatMonth.setStatus(rs.getInt("status"));
        txConsultUserStatMonth.setSourceType(rs.getInt("source_type"));
        txConsultUserStatMonth.setNumber(rs.getInt("number"));
        return txConsultUserStatMonth;
    }
}

