/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.sync.dao.impl;

import com.baijia.tianxiao.dal.sync.dao.TxConsultSourceStatisticMonthDao;
import com.baijia.tianxiao.dal.sync.po.TxConsultSourceStatisticMonth;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class TxConsultSourceStatisticMonthImpl
extends JdbcTemplateDaoSupport<TxConsultSourceStatisticMonth>
implements TxConsultSourceStatisticMonthDao {
    private static final Logger log = LoggerFactory.getLogger(TxConsultSourceStatisticMonthImpl.class);

    @Override
    public List<TxConsultSourceStatisticMonth> getTxConsultSourceStatisticMonthBySource(Long orgId, Long consultUserId, Integer sourceType, Date startTime, Date endTime) {
        log.info("txConsultSourceStatisticMonth orgId {}, consultUserId {}, sourceType {}, startTime {}, endTime {}", new Object[]{orgId, consultUserId, sourceType, startTime, endTime});
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("consultUserId", (Serializable)consultUserId);
        builder.eq("sourceType", (Serializable)sourceType);
        builder.ge("createTime", (Serializable)startTime);
        builder.lt("createTime", (Serializable)endTime);
        builder.asc("createTime");
        return this.queryList(builder);
    }

    @Override
    public int countByOrgSource(Long orgId, int sourceType, Date startTime, Date endTime) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.sum("number");
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("sourceType", (Serializable)Integer.valueOf(sourceType));
        builder.ge("createTime", (Serializable)startTime);
        builder.lt("createTime", (Serializable)endTime);
        log.info("count by org source sql= {},params:{orgId={},sourceType={},startTime={},endTime={}}", new Object[]{builder.toSql(), orgId, sourceType, startTime, endTime});
        Integer num = (Integer)this.queryForObject(builder, Integer.class);
        return num == null ? 0 : num;
    }
}

