/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.signup.dao.impl;

import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class OrgSignupRefundDaoImpl
extends JdbcTemplateDaoSupport<OrgSignupRefund>
implements OrgSignupRefundDao {
    private static final Logger log = LoggerFactory.getLogger(OrgSignupRefundDaoImpl.class);
    private static final String syncUpdateSql = "update yunying.org_signup_refund set class_id = :classId where class_id = -1 and org_id = :orgId and user_id =:userId and course_id = :courseId";

    OrgSignupRefundDaoImpl() {
        super(OrgSignupRefund.class);
    }

    @Override
    public List<OrgSignupRefund> getOrgSignupRefundListByMinId(Long minId, Date lastDate, int maxSize, String ... queryProps) {
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0, (Object)"maxSize is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        if (minId == null || minId == 0L) {
            if (lastDate == null) {
                throw new IllegalArgumentException("must have minId or lastDate");
            }
            builder.gt("createTime", (Serializable)lastDate);
            builder.asc("createTime");
        } else {
            builder.gt("id", (Serializable)minId);
            builder.asc("id");
        }
        builder.setMaxSize(Integer.valueOf(maxSize));
        return this.queryList(builder);
    }

    @Override
    public List<OrgSignupRefund> getOrgSignupRefundListByPurchaseId(Long orgId, Long purchaseId, Long courseId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("signupPurchaseId", (Serializable)purchaseId);
        builder.eq("courseId", (Serializable)courseId);
        return this.queryList(builder);
    }

    @Override
    public List<OrgSignupRefund> getOrgSignupRefundByStudent(Long orgId, Long purchaseId, Long userId, Long courseId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        if (purchaseId != null && purchaseId != 0L) {
            builder.eq("signupPurchaseId", (Serializable)purchaseId);
        }
        builder.eq("userId", (Serializable)userId);
        builder.eq("courseId", (Serializable)courseId);
        builder.desc("id");
        log.debug("getOrgSignupRefundByStudent sql={},params={}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
        return this.queryList(builder);
    }

    @Override
    public int getRefundTime(Long orgId, Long signupPurchaseId, Long courseId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("signupPurchaseId", (Serializable)signupPurchaseId);
        builder.eq("courseId", (Serializable)courseId);
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<OrgSignupRefund> getByPurcahseIds(Set<Long> purchaseIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("signupPurchaseId", purchaseIds);
        return this.queryList(builder);
    }

    @Override
    public List<Integer> listIdsByUserId(Long orgId, Collection<Long> classIds, Long userId, Date startTime, Date endTime) {
        final ArrayList<Integer> result = new ArrayList<Integer>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT id FROM yunying.org_signup_refund WHERE class_id>0");
        builder.append(" AND org_id=:orgId");
        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.append(" AND class_id IN (:classIds)");
        }
        if (userId != null) {
            builder.append(" AND user_id=:userId");
        }
        if (startTime != null) {
            builder.append(" AND create_time>=:startTime");
        }
        if (endTime != null) {
            builder.append(" AND create_time<:endTime");
        }
        builder.append(" ORDER BY create_time DESC");
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("classIds", classIds);
        params.put("userId", userId);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        template.query(builder.toString(), params, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.add(rs.getInt("id"));
                return 1;
            }
        });
        return result;
    }

    @Override
    public List<OrgSignupRefund> listByUserId(Long orgId, Collection<Long> classIds, Long userId, Date startTime, Date endTime) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.gt("classId", (Serializable)Integer.valueOf(0));
        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.in("classId", classIds);
        }
        if (userId != null) {
            builder.eq("userId", (Serializable)userId);
        }
        if (startTime != null) {
            builder.ge("createTime", (Serializable)startTime);
        }
        if (endTime != null) {
            builder.lt("createTime", (Serializable)endTime);
        }
        return this.queryList(builder);
    }

    @Override
    public List<Integer> listIdsByClassId(Long orgId, Long classId, Collection<Long> userIds, Date startTime, Date endTime) {
        final ArrayList<Integer> result = new ArrayList<Integer>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT id FROM yunying.org_signup_refund WHERE class_id>0");
        builder.append(" AND org_id=:orgId");
        if (CollectionUtils.isNotEmpty(userIds)) {
            builder.append(" AND user_id IN (:userIds)");
        }
        if (classId != null) {
            builder.append(" AND class_id=:classId");
        }
        if (startTime != null) {
            builder.append(" AND create_time>=:startTime");
        }
        if (endTime != null) {
            builder.append(" AND create_time<:endTime");
        }
        builder.append(" ORDER BY create_time DESC");
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("classId", classId);
        params.put("userIds", userIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        template.query(builder.toString(), params, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.add(rs.getInt("id"));
                return 1;
            }
        });
        return result;
    }

    @Override
    public List<OrgSignupRefund> listByClassId(Long orgId, Long classId, Collection<Long> userIds, Date startTime, Date endTime) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.gt("classId", (Serializable)Integer.valueOf(0));
        if (CollectionUtils.isNotEmpty(userIds)) {
            builder.in("userId", userIds);
        }
        if (classId != null) {
            builder.eq("classId", (Serializable)classId);
        }
        if (startTime != null) {
            builder.ge("createTime", (Serializable)startTime);
        }
        if (endTime != null) {
            builder.le("createTime", (Serializable)endTime);
        }
        return this.queryList(builder);
    }

    @Override
    public List<Integer> listIdsByClassIds(Collection<Long> classIds, Date startTime, Date endTime) {
        final ArrayList<Integer> result = new ArrayList<Integer>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT id FROM yunying.org_signup_refund WHERE class_id>0");
        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.append(" AND class_id IN (:classIds)");
        }
        if (startTime != null) {
            builder.append(" AND create_time>=:startTime");
        }
        if (endTime != null) {
            builder.append(" AND create_time<:endTime");
        }
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("classIds", classIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        template.query(builder.toString(), params, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.add(rs.getInt("id"));
                return 1;
            }
        });
        return result;
    }

    @Override
    public List<OrgSignupRefund> listByClassIds(Collection<Long> classIds, Date startTime, Date endTime) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.gt("classId", (Serializable)Integer.valueOf(0));
        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.in("classId", classIds);
        }
        if (startTime != null) {
            builder.ge("createTime", (Serializable)startTime);
        }
        if (endTime != null) {
            builder.le("createTime", (Serializable)endTime);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgSignupRefund> listByOrgId(Long orgId, Collection<Long> classIds, Collection<Long> userIds, Date startTime, Date endTime) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.gt("classId", (Serializable)Integer.valueOf(0));
        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.in("classId", classIds);
        }
        if (userIds != null) {
            builder.in("userId", userIds);
        }
        if (startTime != null) {
            builder.ge("createTime", (Serializable)startTime);
        }
        if (endTime != null) {
            builder.le("createTime", (Serializable)endTime);
        }
        return this.queryList(builder);
    }

    @Override
    public Long sumRefundFeeByOrgId(Long orgId, Date startTime, Date endTime) {
        Long result;
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.sum("refundFee");
        builder.gt("classId", (Serializable)Integer.valueOf(0));
        builder.eq("orgId", (Serializable)orgId);
        if (startTime != null) {
            builder.ge("createTime", (Serializable)startTime);
        }
        if (endTime != null) {
            builder.le("createTime", (Serializable)endTime);
        }
        return (result = (Long)this.queryForObject(builder, Long.class)) != null ? result : 0L;
    }

    @Override
    public Long sumRefundFeeByClassId(Long orgId, Long classId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.sum("refundFee");
        builder.gt("classId", (Serializable)Integer.valueOf(0));
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("classId", (Serializable)classId);
        Long result = (Long)this.queryForObject(builder, Long.class);
        return result != null ? result : 0L;
    }

    @Override
    public Long sumRefundFeeByUserId(Long orgId, Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.sum("refundFee");
        builder.gt("classId", (Serializable)Integer.valueOf(0));
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userId", (Serializable)userId);
        Long result = (Long)this.queryForObject(builder, Long.class);
        return result != null ? result : 0L;
    }

    @Override
    public Long sumRefundFeeByClassIds(Collection<Long> classIds, Date startTime, Date endTime) {
        Long result;
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.sum("refundFee");
        builder.gt("classId", (Serializable)Integer.valueOf(0));
        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.in("classId", classIds);
        }
        if (startTime != null) {
            builder.ge("createTime", (Serializable)startTime);
        }
        if (endTime != null) {
            builder.le("createTime", (Serializable)endTime);
        }
        return (result = (Long)this.queryForObject(builder, Long.class)) != null ? result : 0L;
    }

    @Override
    public Long sumRefundFeeByUserIds(Long orgId, Collection<Long> userIds, Date startTime, Date endTime) {
        Long result;
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("refundFee");
        builder.gt("classId", (Serializable)Integer.valueOf(0));
        builder.eq("orgId", (Serializable)orgId);
        if (userIds != null) {
            builder.in("userId", userIds);
        }
        if (startTime != null) {
            builder.ge("createTime", (Serializable)startTime);
        }
        if (endTime != null) {
            builder.le("createTime", (Serializable)endTime);
        }
        return (result = (Long)this.queryForObject(builder, Long.class)) != null ? result : 0L;
    }

    @Override
    public Long sumRefundFeeByOrgIds(Collection<Long> orgIds, Date startTime, Date endTime) {
        Long result;
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.sum("refundFee");
        builder.gt("classId", (Serializable)Integer.valueOf(0));
        builder.in("orgId", orgIds);
        if (startTime != null) {
            builder.ge("createTime", (Serializable)startTime);
        }
        if (endTime != null) {
            builder.le("createTime", (Serializable)endTime);
        }
        return (result = (Long)this.queryForObject(builder, Long.class)) != null ? result : 0L;
    }

    @Override
    public Map<Long, Long> mapRefundFeeByOrgIds(Collection<Long> orgIds, Date startTime, Date endTime) {
        final HashMap<Long, Long> result = new HashMap<Long, Long>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT org_id, sum(refund_fee) AS refund_fee FROM yunying.org_signup_refund WHERE class_id>0");
        if (CollectionUtils.isNotEmpty(orgIds)) {
            builder.append(" AND org_id IN (:orgIds)");
        }
        if (startTime != null) {
            builder.append(" AND create_time>=:startTime");
        }
        if (endTime != null) {
            builder.append(" AND create_time<=:endTime");
        }
        builder.append(" GROUP BY org_id");
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgIds", orgIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        template.query(builder.toString(), params, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.put(rs.getLong("org_id"), rs.getLong("refund_fee"));
                return 1;
            }
        });
        return result;
    }

    @Override
    public Map<Long, Long> mapRefundFeeByClassIds(Collection<Long> classIds, Date startTime, Date endTime) {
        final HashMap<Long, Long> result = new HashMap<Long, Long>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT class_id, sum(refund_fee) AS refund_fee FROM yunying.org_signup_refund WHERE class_id>0");
        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.append(" AND class_id IN (:classIds)");
        }
        if (startTime != null) {
            builder.append(" AND create_time>=:startTime");
        }
        if (endTime != null) {
            builder.append(" AND create_time<=:endTime");
        }
        builder.append(" GROUP BY class_id");
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("classIds", classIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        template.query(builder.toString(), params, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.put(rs.getLong("class_id"), rs.getLong("refund_fee"));
                return 1;
            }
        });
        return result;
    }

    @Override
    public Map<Long, Long> mapRefundFeeByUserIds(Long orgId, Collection<Long> userIds, Date startTime, Date endTime) {
        final HashMap<Long, Long> result = new HashMap<Long, Long>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT user_id, sum(refund_fee) AS refund_fee FROM yunying.org_signup_refund WHERE class_id>0");
        builder.append(" AND org_id=:orgId");
        if (CollectionUtils.isNotEmpty(userIds)) {
            builder.append(" AND user_id IN (:userIds)");
        }
        if (startTime != null) {
            builder.append(" AND create_time>=:startTime");
        }
        if (endTime != null) {
            builder.append(" AND create_time<=:endTime");
        }
        builder.append(" GROUP BY user_id");
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("userIds", userIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        template.query(builder.toString(), params, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.put(rs.getLong("user_id"), rs.getLong("refund_fee"));
                return 1;
            }
        });
        return result;
    }

    @Override
    public void syncRealCourseId(Collection<String> syncDatas) {
        if (GenericsUtils.isNullOrEmpty(syncDatas)) {
            return;
        }
        HashMap paramMap = Maps.newHashMap();
        for (String syncDataStr : syncDatas) {
            List stringToNumber = GenericsUtils.stringToNumberList((String)syncDataStr, (String)"_", Long.class);
            Long userId = (Long)stringToNumber.get(0);
            Long courseId = (Long)stringToNumber.get(1);
            Long orgId = (Long)stringToNumber.get(2);
            Long classId = (Long)stringToNumber.get(3);
            paramMap.put("userId", userId);
            paramMap.put("courseId", courseId);
            paramMap.put("orgId", orgId);
            paramMap.put("classId", classId);
            log.info("update org_signup_refund with sql:{} and paramMap: {}", (Object)syncUpdateSql, (Object)paramMap);
            this.getNamedJdbcTemplate().update(syncUpdateSql, (Map)paramMap);
        }
    }

    @Override
    public List<Long> pageDistinctClassId(Long orgId, Collection<Long> classIds, Date startTime, Date endTime, PageDto pageDto) {
        final ArrayList<Long> result = new ArrayList<Long>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT DISTINCT(class_id) FROM yunying.org_signup_refund WHERE class_id>0");
        if (orgId != null) {
            builder.append(" AND org_id=:orgId");
        }
        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.append(" AND class_id IN (:classIds)");
        }
        if (startTime != null) {
            builder.append(" AND create_time>=:startTime");
        }
        if (endTime != null) {
            builder.append(" AND create_time<=:endTime");
        }
        if (pageDto != null) {
            builder.append(" LIMIT :limitFrom,:limitTo");
        }
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("classIds", classIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        if (pageDto != null) {
            params.put("limitFrom", pageDto.firstNum());
            params.put("limitTo", pageDto.getPageSize());
        }
        template.query(builder.toString(), params, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.add(rs.getLong("class_id"));
                return 1;
            }
        });
        return result;
    }

    @Override
    public List<Long> pageDistinctUserId(Long orgId, Collection<Long> userIds, Date startTime, Date endTime, PageDto pageDto) {
        final ArrayList<Long> result = new ArrayList<Long>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT DISTINCT(user_id) FROM yunying.org_signup_refund WHERE class_id>0");
        if (orgId != null) {
            builder.append(" AND org_id=:orgId");
        }
        if (CollectionUtils.isNotEmpty(userIds)) {
            builder.append(" AND user_id IN (:userIds)");
        }
        if (startTime != null) {
            builder.append(" AND create_time>=:startTime");
        }
        if (endTime != null) {
            builder.append(" AND create_time<=:endTime");
        }
        if (pageDto != null) {
            builder.append(" LIMIT :limitFrom,:limitTo");
        }
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("userIds", userIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        if (pageDto != null) {
            params.put("limitFrom", pageDto.firstNum());
            params.put("limitTo", pageDto.getPageSize());
        }
        template.query(builder.toString(), params, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.add(rs.getLong("user_id"));
                return 1;
            }
        });
        return result;
    }

    @Override
    public List<OrgSignupRefund> pageByClassIds(Long orgId, Collection<Long> classIds, Date startTime, Date endTime, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.gt("classId", (Serializable)Integer.valueOf(0));
        if (orgId != null) {
            builder.eq("orgId", (Serializable)orgId);
        }
        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.in("classIds", classIds);
        }
        if (startTime != null) {
            builder.ge("createTime", (Serializable)startTime);
        }
        if (endTime != null) {
            builder.le("createTime", (Serializable)endTime);
        }
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        return this.queryList(builder);
    }

    @Override
    public Integer countByClassIds(Long orgId, Collection<Long> classIds, Date startTime, Date endTime) {
        Integer result;
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.gt("classId", (Serializable)Integer.valueOf(0));
        if (orgId != null) {
            builder.eq("orgId", (Serializable)orgId);
        }
        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.in("classId", classIds);
        }
        if (startTime != null) {
            builder.ge("createTime", (Serializable)startTime);
        }
        if (endTime != null) {
            builder.le("createTime", (Serializable)endTime);
        }
        return (result = (Integer)this.queryForObject(builder, Integer.class)) != null ? result : 0;
    }

    @Override
    public Map<String, Long> sumRefundMoney(Long orgId, Collection<Long> courseIds, Collection<Long> userIds) {
        if (GenericsUtils.isNullOrEmpty(userIds) || GenericsUtils.isNullOrEmpty(courseIds)) {
            return Maps.newHashMap();
        }
        String sql = "select user_id as userId , course_id as courseId , sum(refund_price + refund_fee) as refundMoney from yunying.org_signup_refund where org_id = :orgId and  user_id in(:userIds) and course_id in(:courseIds) group by user_id,course_id";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("orgId", orgId);
        paramMap.put("userIds", userIds);
        paramMap.put("courseIds", courseIds);
        final HashMap refundMoneyMap = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sql, (Map)paramMap, (ResultSetExtractor)new ResultSetExtractor<Integer>(){

            public Integer extractData(ResultSet rs) throws SQLException, DataAccessException {
                while (rs.next()) {
                    long refundMoney = rs.getLong("refundMoney");
                    long userId = rs.getLong("userId");
                    long courseId = rs.getLong("courseId");
                    refundMoneyMap.put(String.format("%s_%s", userId, courseId), refundMoney);
                }
                return null;
            }
        });
        return refundMoneyMap;
    }

    @Override
    public List<OrgSignupRefund> listOrderByCreateTime(List<Integer> ids) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("id", ids);
        builder.desc("create_time");
        return this.queryList(builder);
    }
}

